/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.securitymanager;

import org.exist.EXistException;
import org.exist.dom.QName;
import org.exist.security.Account;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.storage.DBBroker;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class UMaskFunction
extends BasicFunction {
    private static final QName qnGetUMask = new QName("get-umask", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnSetUMask = new QName("set-umask", "http://exist-db.org/xquery/securitymanager", "sm");
    public static final FunctionSignature FNS_GET_UMASK = new FunctionSignature(qnGetUMask, "Gets the umask of a Users Account.", new SequenceType[]{new FunctionParameterSequenceType("username", 22, 2, "The username of the account to retrieve the umask for.")}, new FunctionReturnSequenceType(38, 7, "The umask of the users account expressed as an integer"));
    public static final FunctionSignature FNS_SET_UMASK = new FunctionSignature(qnSetUMask, "Sets the umask of a Users Account.", new SequenceType[]{new FunctionParameterSequenceType("username", 22, 2, "The username of the account to set the umask for."), new FunctionParameterSequenceType("umask", 38, 2, "The umask to set as an integer.")}, new SequenceType(10, 1));

    public UMaskFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        DBBroker broker = this.getContext().getBroker();
        Subject currentUser = broker.getCurrentSubject();
        if (currentUser.getName().equals("guest")) {
            throw new XPathException("You must be an authenticated user");
        }
        String username = args[0].getStringValue();
        if (this.isCalledAs(qnGetUMask.getLocalPart())) {
            return this.getUMask(broker, username);
        }
        if (this.isCalledAs(qnSetUMask.getLocalPart())) {
            int umask = ((IntegerValue)args[1].itemAt(0)).getInt();
            this.setUMask(broker, currentUser, username, umask);
            return Sequence.EMPTY_SEQUENCE;
        }
        throw new XPathException("Unknown function");
    }

    private IntegerValue getUMask(DBBroker broker, String username) {
        SecurityManager securityManager = broker.getBrokerPool().getSecurityManager();
        Account account = securityManager.getAccount(username);
        return new IntegerValue(account.getUserMask());
    }

    private void setUMask(DBBroker broker, Subject currentUser, String username, int umask) throws XPathException {
        if (!currentUser.hasDbaRole() && !currentUser.getUsername().equals(username)) {
            throw new XPathException((Expression)this, (Throwable)new PermissionDeniedException("You must have suitable access rights to set the users umask."));
        }
        SecurityManager securityManager = broker.getBrokerPool().getSecurityManager();
        Account account = securityManager.getAccount(username);
        account.setUserMask(umask);
        try {
            securityManager.updateAccount(account);
        }
        catch (PermissionDeniedException pde) {
            throw new XPathException((Expression)this, (Throwable)pde);
        }
        catch (EXistException ee) {
            throw new XPathException((Expression)this, (Throwable)ee);
        }
    }
}

