/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.system;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.security.AuthenticationException;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.storage.DBBroker;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class AsUser
extends Function {
    private static final Logger logger = LogManager.getLogger(AsUser.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("as-user", "http://exist-db.org/xquery/system", "system"), "A pseudo-function to execute a limited block of code as a different user. The first argument is the name of the user, the second is the password. If the user can be authenticated, the function will execute the code block given in the third argument with the permissions of that user andreturns the result of the execution. Before the function completes, it switches the current user back to the old user.", new SequenceType[]{new FunctionParameterSequenceType("username", 22, 2, "The username of the user to run the code against"), new FunctionParameterSequenceType("password", 22, 3, "The password of the user to run the code against"), new FunctionParameterSequenceType("code-block", 11, 7, "The code block to run as the identified user")}, new FunctionParameterSequenceType("result", 11, 7, "the results of the code block executed"));

    public AsUser(XQueryContext context) {
        super(context, signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Subject user;
        logger.debug("Entering the system:as-user XQuery function");
        DBBroker broker = this.context.getBroker();
        Sequence usernameResult = this.getArgument(0).eval(contextSequence, contextItem);
        if (usernameResult.isEmpty()) {
            XPathException exception = new XPathException((Expression)this, "No user specified");
            logger.error("No user specified, throwing an exception!", (Throwable)exception);
            throw exception;
        }
        Sequence password = this.getArgument(1).eval(contextSequence, contextItem);
        String username = usernameResult.getStringValue();
        SecurityManager sm = broker.getBrokerPool().getSecurityManager();
        try {
            user = sm.authenticate(username, password.getStringValue());
        }
        catch (AuthenticationException e) {
            XPathException exception = new XPathException((Expression)this, "Authentication failed", (Throwable)e);
            logger.error("Authentication failed for [" + username + "] because of [" + e.getMessage() + "].", (Throwable)exception);
            throw exception;
        }
        logger.info("Setting the effective user to: [" + username + "]");
        try {
            broker.pushSubject(user);
            Sequence sequence = this.getArgument(2).eval(contextSequence, contextItem);
            return sequence;
        }
        finally {
            broker.popSubject();
            logger.info("Returned the effective user to: [" + broker.getCurrentSubject() + "]");
        }
    }

    @Override
    public int getDependencies() {
        return this.getArgument(2).getDependencies();
    }

    @Override
    public int returnsType() {
        return this.getArgument(2).returnsType();
    }
}

