/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.system;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.backup.SystemExport;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FnExport
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(FnExport.class);
    protected static final QName NAME = new QName("export", "http://exist-db.org/xquery/system", "system");
    protected static final String DESCRIPTION = "Export a backup of the database (admin user only).";
    protected static final FunctionParameterSequenceType DIRorFILE = new FunctionParameterSequenceType("dir", 22, 2, "This is an absolute path to where the backup will be written. Must be writeable by the eXist process.");
    protected static final FunctionParameterSequenceType INCREMENTAL = new FunctionParameterSequenceType("incremental", 23, 3, "Flag to do incremental export.");
    protected static final FunctionParameterSequenceType ZIP = new FunctionParameterSequenceType("zip", 23, 3, "Flag to do export to zip file.");
    protected static final FunctionReturnSequenceType RESULT = new FunctionReturnSequenceType(-1, 2, "the export results");
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(NAME, "Export a backup of the database (admin user only).", new SequenceType[]{DIRorFILE, INCREMENTAL, ZIP}, new FunctionReturnSequenceType(-1, 2, "the export results")), new FunctionSignature(new QName("export-silently", "http://exist-db.org/xquery/system", "system"), "Export a backup of the database (admin user only). Messagers from exporter reroute to logs.", new SequenceType[]{DIRorFILE, INCREMENTAL, ZIP}, new FunctionReturnSequenceType(23, 2, "the export results"))};
    public static final QName EXPORT_ELEMENT = new QName("export", "http://exist-db.org/xquery/system", "system");

    public FnExport(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (!this.context.getSubject().hasDbaRole()) {
            throw new XPathException((Expression)this, "Permission denied, calling user '" + this.context.getSubject().getName() + "' must be a DBA to kill a running xquery");
        }
        String dirOrFile = args[0].getStringValue();
        boolean incremental = false;
        if (args[1].hasOne()) {
            incremental = args[1].effectiveBooleanValue();
        }
        boolean zip = false;
        if (args[2].hasOne()) {
            zip = args[2].effectiveBooleanValue();
        }
        MemTreeBuilder builder = null;
        if (NAME.equals(this.mySignature.getName())) {
            builder = this.context.getDocumentBuilder();
            builder.startDocument();
            builder.startElement(EXPORT_ELEMENT, null);
        }
        try {
            SystemExport export = new SystemExport(this.context.getBroker(), new Callback(builder), null, true);
            export.export(dirOrFile, incremental, zip, null);
        }
        catch (Exception e) {
            throw new XPathException((Expression)this, "export failed with exception: " + e.getMessage(), (Throwable)e);
        }
        if (builder == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        builder.endElement();
        builder.endDocument();
        return (NodeValue)((Object)builder.getDocument().getDocumentElement());
    }

    private static class Callback
    implements SystemExport.StatusCallback {
        public static final QName COLLECTION_ELEMENT = new QName("collection", "http://exist-db.org/xquery/system", "system");
        public static final QName RESOURCE_ELEMENT = new QName("resource", "http://exist-db.org/xquery/system", "system");
        public static final QName ERROR_ELEMENT = new QName("error", "http://exist-db.org/xquery/system", "system");
        private final MemTreeBuilder builder;

        public Callback(MemTreeBuilder builder) {
            this.builder = builder;
        }

        @Override
        public void startCollection(String path) throws TerminatedException {
            if (this.builder == null) {
                SystemExport.LOG.info("Collection " + path);
            } else {
                this.builder.startElement(COLLECTION_ELEMENT, null);
                this.builder.characters(path);
                this.builder.endElement();
            }
        }

        @Override
        public void startDocument(String name, int current, int count) throws TerminatedException {
            if (this.builder == null) {
                SystemExport.LOG.info("Document " + name);
            } else {
                this.builder.startElement(RESOURCE_ELEMENT, null);
                this.builder.characters(name);
                this.builder.endElement();
            }
        }

        @Override
        public void error(String message, Throwable exception) {
            if (this.builder == null) {
                SystemExport.LOG.error(message, exception);
            } else {
                this.builder.startElement(ERROR_ELEMENT, null);
                this.builder.characters(message);
                this.builder.endElement();
            }
        }
    }
}

