/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.system;

import java.nio.file.Path;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;

public class GetExistHome
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(GetExistHome.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-exist-home", "http://exist-db.org/xquery/system", "system"), "Returns the eXist home location.", FunctionSignature.NO_ARGS, new FunctionReturnSequenceType(22, 2, "the path to the eXist home"));

    public GetExistHome(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Optional<Path> existHome = this.context.getBroker().getConfiguration().getExistHome();
        return existHome.map(h -> new StringValue(h.toAbsolutePath().toString())).orElse(Sequence.EMPTY_SEQUENCE);
    }
}

