/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.system;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.DocumentImpl;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.memtree.SAXAdapter;
import org.exist.storage.statistics.IndexStatistics;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.xml.sax.SAXException;

public class GetIndexStatistics
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(GetIndexStatistics.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-index-statistics", "http://exist-db.org/xquery/system", "system"), "Internal function", null, new FunctionReturnSequenceType(-1, 3, "the resource containing the index statistics"));

    public GetIndexStatistics(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        IndexStatistics index = (IndexStatistics)this.context.getBroker().getBrokerPool().getIndexManager().getIndexById(IndexStatistics.ID);
        if (index == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        SAXAdapter adapter = new SAXAdapter(this.context);
        try {
            adapter.startDocument();
            index.toSAX(adapter);
            adapter.endDocument();
        }
        catch (SAXException e) {
            throw new XPathException((Expression)this, "Error caught while retrieving statistics: " + e.getMessage(), (Throwable)e);
        }
        DocumentImpl doc = adapter.getDocument();
        return (NodeImpl)doc.getFirstChild();
    }
}

