/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.system;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.scheduler.ScheduledJobInfo;
import org.exist.scheduler.Scheduler;
import org.exist.storage.BrokerPool;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;

public class GetScheduledJobs
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(GetScheduledJobs.class);
    private static final String TODAY_TIMESTAMP = "HH:mm:ss.SSS Z";
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS Z";
    static final String NAMESPACE_URI = "http://exist-db.org/xquery/system";
    static final String PREFIX = "system";
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-scheduled-jobs", "http://exist-db.org/xquery/system", "system"), "Get a list of scheduled jobs (dba role only).", null, new FunctionReturnSequenceType(11, 2, "a node containing the list of scheduled jobs"));

    public GetScheduledJobs(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Scheduler existScheduler;
        if (!this.context.getSubject().hasDbaRole()) {
            XPathException xPathException = new XPathException((Expression)this, "Permission denied, calling user '" + this.context.getSubject().getName() + "' must be a DBA to get the list of scheduled jobs");
            logger.error("Invalid user system:get-scheduled-jobs", (Throwable)xPathException);
            throw xPathException;
        }
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        builder.startDocument();
        builder.startElement(new QName("jobs", NAMESPACE_URI, PREFIX), null);
        BrokerPool brokerPool = this.context.getBroker().getBrokerPool();
        logger.trace("brokerPool = " + brokerPool.toString());
        if (brokerPool != null && (existScheduler = brokerPool.getScheduler()) != null) {
            List<ScheduledJobInfo> scheduledJobsInfo = existScheduler.getScheduledJobs();
            ScheduledJobInfo[] executingJobsInfo = existScheduler.getExecutingJobs();
            if (scheduledJobsInfo != null) {
                for (ScheduledJobInfo scheduledJobInfo : scheduledJobsInfo) {
                    this.addRow(scheduledJobInfo, builder, false);
                }
            }
            if (executingJobsInfo != null) {
                for (ScheduledJobInfo jobInfo : executingJobsInfo) {
                    this.addRow(jobInfo, builder, true);
                }
            }
        }
        builder.endElement();
        builder.endDocument();
        return (NodeValue)((Object)builder.getDocument().getDocumentElement());
    }

    private void addRow(ScheduledJobInfo scheduledJobInfo, MemTreeBuilder builder, boolean isRunning) {
        logger.trace("Entring addRow");
        String name = scheduledJobInfo.getName();
        String group = scheduledJobInfo.getGroup();
        String triggerName = scheduledJobInfo.getTriggerName();
        Date startTime = scheduledJobInfo.getStartTime();
        Date endTime = scheduledJobInfo.getEndTime();
        Date fireTime = scheduledJobInfo.getPreviousFireTime();
        Date nextFireTime = scheduledJobInfo.getNextFireTime();
        Date finalFireTime = scheduledJobInfo.getFinalFireTime();
        String triggerExpression = scheduledJobInfo.getTriggerExpression();
        ScheduledJobInfo.TriggerState triggerState = scheduledJobInfo.getTriggerState();
        builder.startElement(new QName("job", NAMESPACE_URI, PREFIX), null);
        builder.addAttribute(new QName("name", null, null), name);
        builder.addAttribute(new QName("group", null, null), group);
        builder.addAttribute(new QName("triggerName", null, null), triggerName);
        builder.addAttribute(new QName("startTime", null, null), this.dateText(startTime));
        builder.addAttribute(new QName("endTime", null, null), this.dateText(endTime));
        builder.addAttribute(new QName("fireTime", null, null), this.dateText(fireTime));
        builder.addAttribute(new QName("nextFireTime", null, null), this.dateText(nextFireTime));
        builder.addAttribute(new QName("finalFireTime", null, null), this.dateText(finalFireTime));
        builder.addAttribute(new QName("triggerExpression", null, null), triggerExpression);
        builder.addAttribute(new QName("triggerState", null, null), triggerState.name());
        builder.addAttribute(new QName("running", null, null), isRunning ? "RUNNING" : "SCHEDULED");
        builder.endElement();
        logger.trace("Exiting addRow");
    }

    private String dateText(Date aDate) {
        String returnValue = "";
        if (aDate != null) {
            String formatString = DATE_TIME_FORMAT;
            if (this.isToday(aDate)) {
                formatString = TODAY_TIMESTAMP;
            }
            SimpleDateFormat format = new SimpleDateFormat(formatString);
            returnValue = format.format(aDate);
        }
        return returnValue;
    }

    private boolean isToday(Date aDate) {
        Calendar aCal1 = Calendar.getInstance();
        aCal1.setTime(aDate);
        Calendar aCal2 = Calendar.getInstance();
        return aCal1.get(5) == aCal2.get(5) && aCal1.get(1) == aCal2.get(1) && aCal1.get(2) == aCal2.get(2);
    }
}

