/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.system;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;

public class GetUptime
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(GetUptime.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-uptime", "http://exist-db.org/xquery/system", "system"), "Returns the time since eXist-db was started. The value is stable over the lifetime of a query.", FunctionSignature.NO_ARGS, new FunctionReturnSequenceType(55, 2, "the duration since eXist-db was started"));

    public GetUptime(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Calendar startupTime = this.context.getBroker().getBrokerPool().getStartupTime();
        XMLGregorianCalendar xmlNow = this.context.getCalendar();
        GregorianCalendar now = xmlNow.toGregorianCalendar();
        long duration = now.getTimeInMillis() - startupTime.getTimeInMillis();
        return new DayTimeDurationValue(duration);
    }
}

