/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.system;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.storage.BrokerPool;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class Shutdown
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(Shutdown.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("shutdown", "http://exist-db.org/xquery/system", "system"), "Shutdown eXist immediately.  This method is only available to the DBA role.", null, new SequenceType(11, 1)), new FunctionSignature(new QName("shutdown", "http://exist-db.org/xquery/system", "system"), "Shutdown eXist.  This method is only available to the DBA role.", new SequenceType[]{new FunctionParameterSequenceType("delay", 37, 2, "The delay in milliseconds before eXist starts to shutdown.")}, new SequenceType(11, 1))};

    public Shutdown(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.context.getSubject().hasDbaRole()) {
            long delay = 0L;
            if (args.length == 1 && !args[0].isEmpty()) {
                delay = ((NumericValue)args[0].itemAt(0)).getLong();
            }
            BrokerPool pool = this.context.getBroker().getBrokerPool();
            if (delay > 0L) {
                logger.info("Shutdown in " + delay + " milliseconds.");
                DelayedShutdownTask task = new DelayedShutdownTask(pool);
                Timer timer = new Timer("eXist-db shutdown schedule", true);
                timer.schedule((TimerTask)task, delay);
            } else {
                logger.info("Shutting down now.");
                pool.shutdown();
            }
        } else {
            XPathException xPathException = new XPathException((Expression)this, "Permission denied, calling user '" + this.context.getSubject().getName() + "' must be a DBA to shutdown the database");
            logger.error("Invalid user", (Throwable)xPathException);
            throw xPathException;
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    private static class DelayedShutdownTask
    extends TimerTask {
        private BrokerPool pool = null;

        public DelayedShutdownTask(BrokerPool pool) {
            this.pool = pool;
        }

        @Override
        public void run() {
            logger.info("Shutting down now.");
            this.pool.shutdown();
        }
    }
}

