/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.system;

import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.dom.QName;
import org.exist.storage.SystemTask;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TriggerSystemTask
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(TriggerSystemTask.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("trigger-system-task", "http://exist-db.org/xquery/system", "system"), "Trigger a system task.", new SequenceType[]{new FunctionParameterSequenceType("java-classname", 22, 2, "The full name of the Java class to execute.  It must implement org.exist.storage.SystemTask"), new FunctionParameterSequenceType("task-parameters", -1, 3, "The XML fragment with the following structure: <parameters><param name=\"param-name1\" value=\"param-value1\"/></parameters>")}, new SequenceType(11, 1));

    public TriggerSystemTask(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String className = args[0].getStringValue();
        Properties properties = new Properties();
        if (args[1].hasOne()) {
            this.parseParameters(((NodeValue)args[1].itemAt(0)).getNode(), properties);
        }
        try {
            Class<?> clazz = Class.forName(className);
            Object taskObject = clazz.newInstance();
            if (!(taskObject instanceof SystemTask)) {
                XPathException xPathException = new XPathException((Expression)this, className + " is not an instance of org.exist.storage.SystemTask");
                logger.error("Java classname is not a SystemTask", (Throwable)xPathException);
                throw xPathException;
            }
            SystemTask task = (SystemTask)taskObject;
            task.configure(this.context.getBroker().getConfiguration(), properties);
            LOG.info("Triggering SystemTask: " + className);
            this.context.getBroker().getBrokerPool().triggerSystemTask(task);
        }
        catch (ClassNotFoundException e) {
            String message = "system task class '" + className + "' not found";
            logger.error(message, (Throwable)e);
            throw new XPathException((Expression)this, message);
        }
        catch (InstantiationException e) {
            String message = "system task '" + className + "' can not be instantiated";
            logger.error(message, (Throwable)e);
            throw new XPathException((Expression)this, message);
        }
        catch (IllegalAccessException e) {
            String message = "system task '" + className + "' can not be accessed";
            logger.error(message, (Throwable)e);
            throw new XPathException((Expression)this, message);
        }
        catch (EXistException e) {
            String message = "system task " + className + " reported an error during initialization: ";
            logger.error(message, (Throwable)e);
            throw new XPathException((Expression)this, message + e.getMessage(), (Throwable)e);
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    private void parseParameters(Node options, Properties properties) throws XPathException {
        if (options.getNodeType() == 1 && "parameters".equals(options.getLocalName())) {
            for (Node child = options.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !"param".equals(child.getLocalName())) continue;
                Element elem = (Element)child;
                String name = elem.getAttribute("name");
                String value = elem.getAttribute("value");
                logger.trace("parseParameters: name[" + name + "] value[" + value + "]");
                if (name == null || value == null) {
                    throw new XPathException((Expression)this, "Name or value attribute missing for stylesheet parameter");
                }
                properties.setProperty(name, value);
            }
        }
    }
}

