/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.transform;

import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.xmldb.XmldbURI;

public class EXistURIResolver
implements URIResolver {
    private static final Logger LOG = LogManager.getLogger(EXistURIResolver.class);
    final DBBroker broker;
    final String basePath;

    public EXistURIResolver(DBBroker broker, String docPath) {
        this.broker = broker;
        this.basePath = docPath;
        LOG.debug("EXistURIResolver base path set to " + this.basePath);
    }

    private String normalizePath(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("normalizePath may only be applied to an absolute path; argument was: " + path + "; base: " + this.basePath);
        }
        String[] pathComponents = path.substring(1).split("/");
        int numPathComponents = Array.getLength(pathComponents);
        String[] simplifiedComponents = new String[numPathComponents];
        int numSimplifiedComponents = 0;
        for (String s : pathComponents) {
            if (s.length() == 0 || ".".equals(s)) continue;
            if ("..".equals(s)) {
                if (numSimplifiedComponents <= 0) continue;
                --numSimplifiedComponents;
                continue;
            }
            simplifiedComponents[numSimplifiedComponents++] = s;
        }
        if (numSimplifiedComponents == 0) {
            return "/";
        }
        StringBuilder b = new StringBuilder(path.length());
        for (int x = 0; x < numSimplifiedComponents; ++x) {
            b.append("/").append(simplifiedComponents[x]);
        }
        if (path.endsWith("/")) {
            b.append("/");
        }
        return b.toString();
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        String path;
        if (href.isEmpty()) {
            path = base;
        } else {
            URI hrefURI = null;
            try {
                hrefURI = new URI(href);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (hrefURI != null && hrefURI.isAbsolute()) {
                path = href;
            } else if (href.startsWith("/")) {
                path = href;
            } else if (href.startsWith("xmldb:exist://")) {
                path = href.substring("xmldb:exist://".length());
            } else if (base == null || base.length() == 0) {
                path = this.basePath + "/" + href;
            } else {
                if (base.startsWith("xmldb:exist://")) {
                    base = base.substring("xmldb:exist://".length());
                }
                path = base.substring(0, base.lastIndexOf("/") + 1) + href;
            }
        }
        LOG.debug("Resolving path " + href + " with base " + base + " to " + path);
        if (path.startsWith("/")) {
            path = this.normalizePath(path);
            return this.databaseSource(path);
        }
        return this.urlSource(path);
    }

    private Source urlSource(String path) throws TransformerException {
        try {
            URL url = new URL(path);
            return new StreamSource(url.openStream());
        }
        catch (IOException e) {
            throw new TransformerException(e.getMessage(), e);
        }
    }

    private Source databaseSource(String path) throws TransformerException {
        XmldbURI uri = XmldbURI.create(path);
        try {
            DocumentImpl doc = this.broker.getResource(uri, 4);
            if (doc == null) {
                LOG.error("Document " + path + " not found");
                throw new TransformerException("Resource " + path + " not found in database.");
            }
            if (doc instanceof BinaryDocument) {
                Path p = this.broker.getBinaryFile((BinaryDocument)doc);
                StreamSource source = new StreamSource(p.toFile());
                source.setSystemId(p.toUri().toString());
                return source;
            }
            DOMSource source = new DOMSource(doc);
            source.setSystemId(uri.toASCIIString());
            return source;
        }
        catch (IOException | PermissionDeniedException e) {
            throw new TransformerException(e.getMessage(), e);
        }
    }
}

