/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.util.Base64Decoder;
import org.exist.util.Base64Encoder;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class Base64Functions
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(Base64Functions.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("base64-encode", "http://exist-db.org/xquery/util", "util"), "Encodes the given string as Base64", new SequenceType[]{new FunctionParameterSequenceType("string", 22, 3, "The string to be Base64 encoded")}, new FunctionReturnSequenceType(22, 3, "the Base64 encoded output, with trailing newlines trimmed")), new FunctionSignature(new QName("base64-encode", "http://exist-db.org/xquery/util", "util"), "Encodes the given string as Base64", new SequenceType[]{new FunctionParameterSequenceType("string", 22, 3, "The string to be Base64 encoded"), new FunctionParameterSequenceType("trim", 23, 2, "Trim trailing newlines?")}, new FunctionReturnSequenceType(22, 3, "the Base64 encoded output")), new FunctionSignature(new QName("base64-decode", "http://exist-db.org/xquery/util", "util"), "Decode the given Base64 encoded string back to clear text", new SequenceType[]{new FunctionParameterSequenceType("string", 22, 3, "The Base64 string to be decoded")}, new FunctionReturnSequenceType(22, 3, "the decoded output"))};

    public Base64Functions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence value = Sequence.EMPTY_SEQUENCE;
        boolean trim = true;
        if (!args[0].isEmpty()) {
            String str = args[0].getStringValue();
            if (args.length == 2) {
                trim = args[1].effectiveBooleanValue();
            }
            if (this.isCalledAs("base64-encode")) {
                Base64Encoder enc = new Base64Encoder();
                enc.translate(str.getBytes());
                value = trim ? new StringValue(new String(enc.getCharArray()).trim()) : new StringValue(new String(enc.getCharArray()));
            } else {
                Base64Decoder dec = new Base64Decoder();
                dec.translate(str);
                value = new StringValue(new String(dec.getByteArray()));
            }
        }
        return value;
    }
}

