/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class BaseConversionFunctions
extends BasicFunction {
    private static final QName qnIntToOctal = new QName("int-to-octal", "http://exist-db.org/xquery/util", "util");
    private static final QName qnOctalToInt = new QName("octal-to-int", "http://exist-db.org/xquery/util", "util");
    public static final FunctionSignature FNS_INT_TO_OCTAL = new FunctionSignature(qnIntToOctal, "Converts an int e.g. 511 to an octal number e.g. 0777.", new SequenceType[]{new FunctionParameterSequenceType("int", 38, 2, "The int to convert to an octal string.")}, new SequenceType(22, 2));
    public static final FunctionSignature FNS_OCTAL_TO_INT = new FunctionSignature(qnOctalToInt, "Converts an octal string e.g. '0777' to an int e.g. 511.", new SequenceType[]{new FunctionParameterSequenceType("octal", 22, 2, "The octal string to convert to an int.")}, new SequenceType(38, 2));

    public BaseConversionFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.isCalledAs(qnIntToOctal.getLocalPart())) {
            int i = args[0].toJavaObject(Integer.class);
            String octal = i == 0 ? "0" : "0" + Integer.toOctalString(i);
            return new StringValue(octal);
        }
        if (this.isCalledAs(qnOctalToInt.getLocalPart())) {
            String octal = args[0].toString();
            return new IntegerValue(Integer.parseInt(octal, 8));
        }
        throw new XPathException("Unknown function call: " + this.getSignature());
    }
}

