/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.util.Iterator;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Module;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.fn.FunOnFunctions;
import org.exist.xquery.functions.inspect.ModuleFunctions;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;

public class BuiltinFunctions
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(BuiltinFunctions.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("registered-functions", "http://exist-db.org/xquery/util", "util"), "Returns a sequence containing the QNames of all functions declared in the module identified by the specified namespace URI. An error is raised if no module is found for the specified URI.", new SequenceType[]{new FunctionParameterSequenceType("namespace-uri", 22, 2, "The namespace URI of the function module")}, new FunctionReturnSequenceType(22, 6, "the sequence of function names")), new FunctionSignature(new QName("registered-functions", "http://exist-db.org/xquery/util", "util"), "Returns a sequence containing the QNames of all functions currently known to the system, including functions in imported and built-in modules.", null, new FunctionReturnSequenceType(22, 6, "the sequence of function names")), new FunctionSignature(new QName("declared-variables", "http://exist-db.org/xquery/util", "util"), "Returns a sequence containing the QNames of all functions declared in the module identified by the specified namespace URI. An error is raised if no module is found for the specified URI.", new SequenceType[]{new FunctionParameterSequenceType("namespace-uri", 22, 2, "The namespace URI of the function module")}, new FunctionReturnSequenceType(22, 6, "the sequence of function names")), new FunctionSignature(new QName("list-functions", "http://exist-db.org/xquery/util", "util"), "Returns a sequence of function items for each function in the current module.", null, (SequenceType)new FunctionReturnSequenceType(101, 7, "sequence of function references"), ModuleFunctions.FNS_MODULE_FUNCTIONS_CURRENT), new FunctionSignature(new QName("list-functions", "http://exist-db.org/xquery/util", "util"), "Returns a sequence of function items for each function in the specified module.", new SequenceType[]{new FunctionParameterSequenceType("namespace-uri", 22, 2, "The namespace URI of the function module")}, (SequenceType)new FunctionReturnSequenceType(101, 7, "sequence of function references"), ModuleFunctions.FNS_MODULE_FUNCTIONS_OTHER)};

    public BuiltinFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        ValueSequence resultSeq = new ValueSequence();
        if (this.getArgumentCount() == 1) {
            String uri = args[0].getStringValue();
            Module module = this.context.getModule(uri);
            if (module == null) {
                throw new XPathException((Expression)this, "No module found matching namespace URI: " + uri);
            }
            if (this.isCalledAs("declared-variables")) {
                this.addVariablesFromModule(resultSeq, module);
            } else if (this.isCalledAs("list-functions")) {
                this.addFunctionRefsFromModule(resultSeq, module);
            } else {
                this.addFunctionsFromModule(resultSeq, module);
            }
        } else if (this.isCalledAs("list-functions")) {
            this.addFunctionRefsFromContext(resultSeq);
        } else {
            Iterator<Object> i = this.context.getModules();
            while (i.hasNext()) {
                Module module = i.next();
                this.addFunctionsFromModule(resultSeq, module);
            }
            i = this.context.localFunctions();
            while (i.hasNext()) {
                UserDefinedFunction func = (UserDefinedFunction)i.next();
                FunctionSignature sig = func.getSignature();
                resultSeq.add(new QNameValue(this.context, sig.getName()));
            }
        }
        return resultSeq;
    }

    private void addFunctionsFromModule(ValueSequence resultSeq, Module module) {
        TreeSet<QName> set = new TreeSet<QName>();
        FunctionSignature[] signatures = module.listFunctions();
        for (FunctionSignature signature : signatures) {
            QName qname = signature.getName();
            set.add(qname);
        }
        for (QName qname : set) {
            resultSeq.add(new QNameValue(this.context, qname));
        }
    }

    private void addFunctionRefsFromModule(ValueSequence resultSeq, Module module) throws XPathException {
        FunctionSignature[] signatures;
        for (FunctionSignature signature : signatures = module.listFunctions()) {
            FunctionCall call = FunOnFunctions.lookupFunction(this, signature.getName(), signature.getArgumentCount());
            if (call == null) continue;
            resultSeq.add(new FunctionReference(call));
        }
    }

    private void addFunctionRefsFromContext(ValueSequence resultSeq) throws XPathException {
        Iterator<UserDefinedFunction> i = this.context.localFunctions();
        while (i.hasNext()) {
            UserDefinedFunction f = i.next();
            FunctionCall call = FunOnFunctions.lookupFunction(this, f.getSignature().getName(), f.getSignature().getArgumentCount());
            if (call == null) continue;
            resultSeq.add(new FunctionReference(call));
        }
    }

    private void addVariablesFromModule(ValueSequence resultSeq, Module module) {
        Iterator<QName> i = module.getGlobalVariables();
        while (i.hasNext()) {
            resultSeq.add(new QNameValue(this.context, i.next()));
        }
    }
}

