/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class CallFunction
extends Function {
    protected static final Logger logger = LogManager.getLogger(CallFunction.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("call", "http://exist-db.org/xquery/util", "util"), "Invokes a first-class function reference created by util:function. The function to be called is passed as the first argument. All remaining arguments are forwarded to the called function.", new SequenceType[]{new FunctionParameterSequenceType("function-reference", 101, 2, "The function to ba called"), new FunctionParameterSequenceType("parameters", 11, 7, "The parameters to be passed into the function")}, (SequenceType)new FunctionReturnSequenceType(11, 7, "the results from the function called"), true);

    public CallFunction(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence arg0 = this.getArgument(0).eval(contextSequence, contextItem);
        if (arg0.getCardinality() != 2) {
            throw new XPathException((Expression)this, "Expected exactly one item for first argument");
        }
        Item item0 = arg0.itemAt(0);
        if (item0.getType() != 101) {
            throw new XPathException((Expression)this, "Type error: expected function, got " + Type.getTypeName(item0.getType()));
        }
        FunctionReference ref = (FunctionReference)item0;
        ArrayList<Expression> params = new ArrayList<Expression>(this.getArgumentCount() - 1);
        for (int i = 1; i < this.getArgumentCount(); ++i) {
            params.add(this.getArgument(i));
        }
        ref.setArguments(params);
        ref.analyze(new AnalyzeContextInfo(this, 0));
        return ref.eval(contextSequence);
    }
}

