/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.util.UtilModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class CatchFunction
extends Function {
    protected static final Logger logger = LogManager.getLogger(CatchFunction.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("catch", "http://exist-db.org/xquery/util", "util"), "This function corresponds to a try-catch statement in Java. The code block in $try-code-blocks will be put inside a try-catch statement. If an exception is thrown while executing $try-code-blocks, the function checks the name of the exception and calls $catch-code-blocks if it matches one of the fully qualified Java class names specified in $java-classnames. A value of \"*\" in $java-classnames will catch all java exceptions. Inside the catch code block, the variable $util:exception will be bound to the java class name of the exception, $util:exception-message will be bound to the message produced by the exception, and $util:error-code will be bound to the xs:QName error code.", new SequenceType[]{new FunctionParameterSequenceType("java-classnames", 22, 6, "The list of one or more fully qualified Java class names.  An entry of '*' will catch all java exceptions."), new FunctionParameterSequenceType("try-code-blocks", 11, 7, "The code blocks that will be put inside of a the try part of the try-catch statement."), new FunctionParameterSequenceType("catch-code-blocks", 11, 7, "The code blocks that will be will called if the catch matches one of the $java-classnames")}, (SequenceType)new FunctionReturnSequenceType(11, 7, "the results from the try-catch"), "Use the XQuery 3.0 try/catch expression instead.");

    public CatchFunction(XQueryContext context) {
        super(context, signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence exceptionClasses = this.getArgument(0).eval(contextSequence, contextItem);
        Sequence result = null;
        this.context.pushDocumentContext();
        LocalVariable mark = this.context.markLocalVariables(false);
        try {
            Sequence sequence = result = this.getArgument(1).eval(contextSequence, contextItem);
            this.context.popDocumentContext();
            this.context.popLocalVariables(mark, result);
            return sequence;
        }
        catch (Throwable throwable) {
            try {
                this.context.popDocumentContext();
                this.context.popLocalVariables(mark, result);
                throw throwable;
            }
            catch (Exception expException) {
                logger.debug("Caught exception in util:catch: " + expException.getMessage());
                if (!(expException instanceof XPathException)) {
                    logger.warn("Exception: " + expException.getMessage(), (Throwable)expException);
                }
                this.context.getWatchDog().reset();
                SequenceIterator i = exceptionClasses.iterate();
                while (i.hasNext()) {
                    Item currentItem = i.nextItem();
                    try {
                        String exClassName = currentItem.getStringValue();
                        Class<?> exClass = null;
                        if (!"*".equals(exClassName)) {
                            exClass = Class.forName(currentItem.getStringValue());
                        }
                        if (!"*".equals(exClassName) && !exClass.getName().equals(expException.getClass().getName()) && !exClass.isInstance(expException)) continue;
                        logger.debug("Calling exception handler to process " + expException.getClass().getName());
                        UtilModule myModule = (UtilModule)this.context.getModule("http://exist-db.org/xquery/util");
                        myModule.declareVariable(UtilModule.EXCEPTION_QNAME, new StringValue(expException.getClass().getName()));
                        myModule.declareVariable(UtilModule.EXCEPTION_MESSAGE_QNAME, new StringValue(expException.getMessage()));
                        QName errorCode = expException instanceof XPathException ? ((XPathException)expException).getErrorCode().getErrorQName() : ErrorCodes.ERROR.getErrorQName();
                        myModule.declareVariable(UtilModule.ERROR_CODE_QNAME, new QNameValue(this.context, errorCode));
                        return this.getArgument(2).eval(contextSequence, contextItem);
                    }
                    catch (Exception e2) {
                        if (e2 instanceof XPathException) {
                            throw (XPathException)e2;
                        }
                        throw new XPathException((Expression)this, "Error in exception handler: " + e2.getMessage(), (Throwable)expException);
                    }
                }
                if (expException instanceof XPathException) {
                    throw (XPathException)expException;
                }
                throw new XPathException((Expression)this, (Throwable)expException);
            }
        }
    }

    @Override
    public int returnsType() {
        return this.getArgument(1).returnsType();
    }

    @Override
    public int getCardinality() {
        return this.getArgument(1).getCardinality();
    }
}

