/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URISyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.NodeProxy;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.lock.Lock;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Base64BinaryDocument;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public class DocumentNameOrId
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(DocumentNameOrId.class);
    private static final QName QN_DOCUMENT_NAME = new QName("document-name", "http://exist-db.org/xquery/util", "util");
    private static final QName QN_DOCUMENT_ID = new QName("document-id", "http://exist-db.org/xquery/util", "util");
    private static final QName QN_ABSOLUTE_RESOURCE_ID = new QName("absolute-resource-id", "http://exist-db.org/xquery/util", "util");
    private static final QName QN_GET_RESOURCE_BY_ABSOLUTE_ID = new QName("get-resource-by-absolute-id", "http://exist-db.org/xquery/util", "util");
    private static final SequenceType[] PARAMS = new SequenceType[]{new FunctionParameterSequenceType("node-or-path", 11, 2, "The node or a string path pointing to a resource in the database.")};
    public static final FunctionSignature docNameSignature = new FunctionSignature(QN_DOCUMENT_NAME, "Returns the name of a document (excluding the collection path). The argument can either be a node or a string path pointing to a resource in the database. If the resource does not exist or the node does not belong to a stored document, the empty sequence is returned.", PARAMS, new FunctionReturnSequenceType(22, 3, "the name of the document"));
    public static final FunctionSignature docIdSignature = new FunctionSignature(QN_DOCUMENT_ID, "Returns the internal integer id of a document. The argument can either be a node or a string path pointing to a resource in the database. If the resource does not exist or the node does not belong to a stored document, the empty sequence is returned.", PARAMS, new FunctionReturnSequenceType(38, 3, "the ID of the document"));
    public static final FunctionSignature absoluteResourceIdSignature = new FunctionSignature(QN_ABSOLUTE_RESOURCE_ID, "Returns the absolute internal id of a resource as a 65 bit number. The first 32 bits are the collection id, the next 32 bits are the document id, the last bit is the document type. The argument can either be a node or a string path pointing to a resource in the database. If the resource does not exist or the node does not belong to a stored document, the empty sequence is returned.", PARAMS, new FunctionReturnSequenceType(31, 3, "the absolute ID of the resource"));
    public static final FunctionSignature resourceByAbsoluteIdSignature = new FunctionSignature(QN_GET_RESOURCE_BY_ABSOLUTE_ID, "Returns the resource indicated by its absolute internal id. The first 32 bits are the collection id, the next 32 bits are the document id, the last bit is the document type. If the resource does not exist, the empty sequence is returned.", new SequenceType[]{new FunctionParameterSequenceType("absolute-id", 31, 2, "The absolute id of a resource in the database.")}, new FunctionReturnSequenceType(11, 3, "The resource from the database. A document() if its an XML resource, or an xs:base64binary otherwise"));

    public DocumentNameOrId(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result = Sequence.EMPTY_SEQUENCE;
        DocumentImpl doc = null;
        try {
            if (Type.subTypeOf(args[0].getItemType(), -1)) {
                NodeValue node = (NodeValue)args[0].itemAt(0);
                if (node.getImplementationType() == 1) {
                    NodeProxy proxy = (NodeProxy)node;
                    doc = proxy.getOwnerDocument();
                    doc.getUpdateLock().acquire(Lock.LockMode.READ_LOCK);
                }
            } else if (Type.subTypeOf(args[0].getItemType(), 22)) {
                String path = args[0].getStringValue();
                doc = this.context.getBroker().getXMLResource(XmldbURI.xmldbUriFor(path), Lock.LockMode.READ_LOCK);
            }
            QName fnName = this.getSignature().getName();
            if (doc != null) {
                if (fnName.equals(QN_DOCUMENT_NAME)) {
                    result = new StringValue(doc.getFileURI().toString());
                } else if (fnName.equals(QN_DOCUMENT_ID)) {
                    result = new IntegerValue(doc.getDocId(), 38);
                } else if (fnName.equals(QN_ABSOLUTE_RESOURCE_ID)) {
                    BigInteger absoluteId = BigInteger.valueOf(doc.getCollection().getId());
                    absoluteId = absoluteId.shiftLeft(32);
                    absoluteId = absoluteId.or(BigInteger.valueOf(doc.getDocId()));
                    absoluteId = absoluteId.shiftLeft(1);
                    absoluteId = absoluteId.or(BigInteger.valueOf(doc.getResourceType() & 1));
                    result = new IntegerValue(absoluteId, 31);
                }
            } else if (fnName.equals(QN_GET_RESOURCE_BY_ABSOLUTE_ID)) {
                IntegerValue absoluteIdParam = (IntegerValue)args[0].itemAt(0);
                BigInteger absoluteId = absoluteIdParam.toJavaObject(BigInteger.class);
                byte resourceType = absoluteId.testBit(0) ? (byte)1 : 0;
                absoluteId = absoluteId.shiftRight(1);
                int documentId = absoluteId.and(BigInteger.valueOf(-1L)).intValue();
                absoluteId = absoluteId.shiftRight(32);
                int collectionId = absoluteId.and(BigInteger.valueOf(-1L)).intValue();
                doc = this.context.getBroker().getResourceById(collectionId, resourceType, documentId);
                if (doc instanceof BinaryDocument) {
                    Base64BinaryDocument b64doc;
                    BinaryDocument bin = (BinaryDocument)doc;
                    InputStream is = this.context.getBroker().getBinaryResource(bin);
                    Base64BinaryDocument base64BinaryDocument = b64doc = Base64BinaryDocument.getInstance(this.context, is);
                    return base64BinaryDocument;
                }
                NodeProxy nodeProxy = new NodeProxy(doc);
                return nodeProxy;
            }
        }
        catch (LockException le) {
            throw new XPathException((Expression)this, "Unable to lock resource", (Throwable)le);
        }
        catch (IOException ioe) {
            throw new XPathException((Expression)this, "Unable to read binary resource", (Throwable)ioe);
        }
        catch (URISyntaxException e) {
            throw new XPathException((Expression)this, "Invalid resource uri: " + args[0].getStringValue(), (Throwable)e);
        }
        catch (PermissionDeniedException e) {
            throw new XPathException((Expression)this, args[0].getStringValue() + ": permission denied to read resource");
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
            }
        }
        return result;
    }
}

