/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.Optional;
import java.util.SimpleTimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.datatype.Duration;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.exist.EXistException;
import org.exist.dom.QName;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.memtree.ReferenceNode;
import org.exist.dom.memtree.SAXAdapter;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.security.UUIDGenerator;
import org.exist.source.DBSource;
import org.exist.source.FileSource;
import org.exist.source.Source;
import org.exist.source.SourceFactory;
import org.exist.source.StringSource;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.XQueryPool;
import org.exist.storage.lock.Lock;
import org.exist.util.NamedThreadFactory;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.util.UtilModule;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.EmptySequence;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.TimeUtils;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Eval
extends BasicFunction {
    protected static final FunctionParameterSequenceType EVAL_CONTEXT_ITEM = new FunctionParameterSequenceType("eval-context-item", 11, 3, "the context item against which the expression will be evaluated");
    private static final String evalArgumentText = "The expression to be evaluated.  If it is of type xs:string, the function tries to execute this string as the query. If the first argument is of type xs:anyURI, the function will try to load the query from the resource to which the URI resolves. If the URI has no scheme, it is assumed that the query is stored in the db and the URI is interpreted as a database path. This is the same as calling util:eval(xs:anyURI('xmldb:exist:///db/test/test.xq')). The query inherits the current execution context, i.e. all namespace declarations and variable declarations are visible from within the inner expression. The function returns an empty sequence if a whitespace string is passed.";
    private static final String contextArgumentText = "The query inherits the context described by the XML fragment in this parameter. It should have the format:\n<static-context>\n\t<output-size-limit value=\"-1\"/>\n\t<unbind-namespace uri=\"http://exist.sourceforge.net/NS/exist\"/>\n\t<current-dateTime value=\"dateTime\"/>\n\t<implicit-timezone value=\"duration\"/>\n\t<variable name=\"qname\">variable value</variable>\n\t<default-context>explicitly provide default context here</default-context>\n\t<mapModule namespace=\"uri\" uri=\"uri_to_module\"/>\n</static-context>.\n";
    protected static final FunctionParameterSequenceType EVAL_ARGUMENT = new FunctionParameterSequenceType("expression", 11, 2, "The expression to be evaluated.  If it is of type xs:string, the function tries to execute this string as the query. If the first argument is of type xs:anyURI, the function will try to load the query from the resource to which the URI resolves. If the URI has no scheme, it is assumed that the query is stored in the db and the URI is interpreted as a database path. This is the same as calling util:eval(xs:anyURI('xmldb:exist:///db/test/test.xq')). The query inherits the current execution context, i.e. all namespace declarations and variable declarations are visible from within the inner expression. The function returns an empty sequence if a whitespace string is passed.");
    protected static final FunctionParameterSequenceType INLINE_CONTEXT = new FunctionParameterSequenceType("inline-context", 11, 7, "The inline context");
    protected static final FunctionParameterSequenceType CONTEXT_ARGUMENT = new FunctionParameterSequenceType("context", -1, 3, "The query inherits the context described by the XML fragment in this parameter. It should have the format:\n<static-context>\n\t<output-size-limit value=\"-1\"/>\n\t<unbind-namespace uri=\"http://exist.sourceforge.net/NS/exist\"/>\n\t<current-dateTime value=\"dateTime\"/>\n\t<implicit-timezone value=\"duration\"/>\n\t<variable name=\"qname\">variable value</variable>\n\t<default-context>explicitly provide default context here</default-context>\n\t<mapModule namespace=\"uri\" uri=\"uri_to_module\"/>\n</static-context>.\n");
    protected static final FunctionParameterSequenceType CACHE_FLAG = new FunctionParameterSequenceType("cache-flag", 23, 2, "The flag for whether the compiled query should be cached.  The cached query will be globally available within the db instance.");
    protected static final FunctionParameterSequenceType EXTERNAL_VARIABLE = new FunctionParameterSequenceType("external-variable", 12, 7, "External variables to be bound for the query that is being evaluated. Should be alternating variable QName and value.");
    protected static final FunctionReturnSequenceType RETURN_NODE_TYPE = new FunctionReturnSequenceType(-1, 7, "the results of the evaluated XPath/XQuery expression");
    protected static final FunctionReturnSequenceType RETURN_THREADID_TYPE = new FunctionReturnSequenceType(22, 2, "The ID of the asynchronously executing thread.");
    protected static final FunctionReturnSequenceType RETURN_ITEM_TYPE = new FunctionReturnSequenceType(11, 7, "the results of the evaluated XPath/XQuery expression");
    private static final ExecutorService asyncExecutorService = Executors.newCachedThreadPool(new NamedThreadFactory("asyncEval"));
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("eval", "http://exist-db.org/xquery/util", "util"), "Dynamically evaluates an XPath/XQuery expression. ", new SequenceType[]{EVAL_ARGUMENT}, RETURN_NODE_TYPE), new FunctionSignature(new QName("eval-async", "http://exist-db.org/xquery/util", "util"), "Dynamically evaluates an XPath/XQuery expression asynchronously. The ID of the executing thread is returned.", new SequenceType[]{EVAL_ARGUMENT}, RETURN_NODE_TYPE), new FunctionSignature(new QName("eval", "http://exist-db.org/xquery/util", "util"), "Dynamically evaluates an XPath/XQuery expression. ", new SequenceType[]{EVAL_ARGUMENT, CACHE_FLAG}, RETURN_NODE_TYPE), new FunctionSignature(new QName("eval", "http://exist-db.org/xquery/util", "util"), "Dynamically evaluates an XPath/XQuery expression. ", new SequenceType[]{EVAL_ARGUMENT, CACHE_FLAG, EXTERNAL_VARIABLE}, RETURN_NODE_TYPE), new FunctionSignature(new QName("eval-with-context", "http://exist-db.org/xquery/util", "util"), "Dynamically evaluates an XPath/XQuery expression. ", new SequenceType[]{EVAL_ARGUMENT, CONTEXT_ARGUMENT, CACHE_FLAG}, RETURN_NODE_TYPE), new FunctionSignature(new QName("eval-with-context", "http://exist-db.org/xquery/util", "util"), "Dynamically evaluates an XPath/XQuery expression.", new SequenceType[]{EVAL_ARGUMENT, CONTEXT_ARGUMENT, CACHE_FLAG, EVAL_CONTEXT_ITEM}, RETURN_NODE_TYPE), new FunctionSignature(new QName("eval-inline", "http://exist-db.org/xquery/util", "util"), "Dynamically evaluates an XPath/XQuery expression.", new SequenceType[]{INLINE_CONTEXT, EVAL_ARGUMENT}, RETURN_ITEM_TYPE), new FunctionSignature(new QName("eval-inline", "http://exist-db.org/xquery/util", "util"), "Dynamically evaluates an XPath/XQuery expression.", new SequenceType[]{INLINE_CONTEXT, EVAL_ARGUMENT, CACHE_FLAG}, RETURN_ITEM_TYPE)};

    public Eval(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        boolean isEvalDisabled = ((UtilModule)this.getParentModule()).isEvalDisabled();
        if (isEvalDisabled) {
            throw new XPathException("util:eval has been disabled by the eXist administrator in conf.xml");
        }
        if (this.isCalledAs("eval-async")) {
            String uuid = UUIDGenerator.getUUID();
            CallableEval asyncEval = new CallableEval(this.context, contextSequence, args);
            asyncExecutorService.submit(asyncEval);
            return new StringValue(uuid);
        }
        return this.doEval(this.context, contextSequence, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence doEval(XQueryContext evalContext, Sequence contextSequence, Sequence[] args) throws XPathException {
        Item contextItem;
        XQueryContext innerContext;
        Source querySource;
        Item expr;
        if (evalContext.getProfiler().isEnabled()) {
            evalContext.getProfiler().start(this);
            evalContext.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                evalContext.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        int argCount = 0;
        Sequence exprContext = null;
        Sequence initContextSequence = null;
        if (this.isCalledAs("eval-inline")) {
            exprContext = args[argCount++];
        }
        if (Type.subTypeOf((expr = args[argCount++].itemAt(0)).getType(), 25)) {
            querySource = this.loadQueryFromURI(expr);
        } else {
            String queryStr = expr.getStringValue();
            if ("".equals(queryStr.trim())) {
                return new EmptySequence();
            }
            querySource = new StringSource(queryStr);
        }
        NodeValue contextInit = null;
        if (this.isCalledAs("eval-with-context")) {
            contextInit = (NodeValue)args[argCount++].itemAt(0);
        }
        boolean cache = false;
        if (argCount < this.getArgumentCount()) {
            cache = ((BooleanValue)args[argCount].itemAt(0)).effectiveBooleanValue();
        }
        evalContext.pushNamespaceContext();
        LocalVariable mark = evalContext.markLocalVariables(false);
        DocumentSet oldDocs = evalContext.getStaticDocs();
        if (exprContext != null) {
            evalContext.setStaticallyKnownDocuments(exprContext.getDocumentSet());
        }
        if (evalContext.isProfilingEnabled(2)) {
            evalContext.getProfiler().start(this, "eval: " + expr);
        }
        XQuery xqueryService = evalContext.getBroker().getBrokerPool().getXQueryService();
        if (contextInit != null) {
            innerContext = new XQueryContext(this.context.getBroker().getBrokerPool());
            initContextSequence = this.initContext(contextInit.getNode(), innerContext);
        } else {
            innerContext = evalContext.copyContext();
            innerContext.setShared(true);
        }
        if (Type.subTypeOf(expr.getType(), 25)) {
            String uri = null;
            Object key = querySource.getKey();
            if (key instanceof XmldbURI) {
                uri = XmldbURI.EMBEDDED_SERVER_URI.append(((XmldbURI)key).removeLastSegment()).toString();
            } else if (key instanceof String && querySource instanceof FileSource) {
                uri = ((FileSource)querySource).getPath().getParent().toString();
            }
            if (uri != null) {
                innerContext.setModuleLoadPath(uri);
            }
        }
        if (this.isCalledAs("eval") && this.getArgumentCount() == 3 && !args[2].isEmpty()) {
            Sequence externalVars = args[2];
            for (int i = 0; i < externalVars.getItemCount(); ++i) {
                Item varName = externalVars.itemAt(i);
                if (varName.getType() != 24) continue;
                Item varValue = externalVars.itemAt(++i);
                innerContext.declareVariable(((QNameValue)varName).getQName(), (Object)varValue);
            }
        }
        if (this.getArgumentCount() == 4 && (contextItem = args[3].itemAt(0)) != null) {
            if (exprContext != null) {
                LOG.warn("exprContext and contextItem are not null");
            }
            exprContext = contextItem.toSequence();
        }
        if (initContextSequence != null) {
            LOG.info("there now");
            exprContext = initContextSequence;
        }
        Sequence result = null;
        try {
            Sequence sequence = result = this.execute(evalContext.getBroker(), xqueryService, querySource, innerContext, exprContext, cache);
            this.cleanup(evalContext, innerContext, oldDocs, mark, expr, result);
            return sequence;
        }
        catch (Throwable throwable) {
            try {
                this.cleanup(evalContext, innerContext, oldDocs, mark, expr, result);
                throw throwable;
            }
            catch (XPathException e) {
                try {
                    e.prependMessage("Error while evaluating expression: " + querySource.getContent() + ". ");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                e.setLocation(this.line, this.column);
                throw e;
            }
        }
    }

    private void cleanup(XQueryContext evalContext, XQueryContext innerContext, DocumentSet oldDocs, LocalVariable mark, Item expr, Sequence resultSequence) {
        if (innerContext != evalContext) {
            innerContext.reset(true);
        }
        if (oldDocs != null) {
            evalContext.setStaticallyKnownDocuments(oldDocs);
        }
        evalContext.popLocalVariables(mark);
        evalContext.popNamespaceContext();
        if (evalContext.isProfilingEnabled(2)) {
            evalContext.getProfiler().end(this, "eval: " + expr, resultSequence);
        }
    }

    private Sequence execute(DBBroker broker, XQuery xqueryService, Source querySource, XQueryContext innerContext, Sequence exprContext, boolean cache) throws XPathException {
        CompiledXQuery compiled = null;
        XQueryPool pool = broker.getBrokerPool().getXQueryPool();
        try {
            CompiledXQuery compiledXQuery = compiled = cache ? pool.borrowCompiledXQuery(broker, querySource) : null;
            if (compiled == null) {
                compiled = xqueryService.compile(broker, innerContext, querySource);
            } else {
                compiled.getContext().updateContext(innerContext);
            }
            Sequence sequence = xqueryService.execute(broker, compiled, exprContext, false);
            ValueSequence newSeq = new ValueSequence();
            newSeq.keepUnOrdered(this.unordered);
            boolean hasSupplements = false;
            for (int i = 0; i < sequence.getItemCount(); ++i) {
                if (Type.subTypeOf(sequence.itemAt(i).getType(), 22)) {
                    newSeq.add(new StringValue(((StringValue)sequence.itemAt(i)).getStringValue(true)));
                    hasSupplements = true;
                    continue;
                }
                newSeq.add(sequence.itemAt(i));
            }
            if (hasSupplements) {
                sequence = newSeq;
            }
            Sequence sequence2 = sequence;
            return sequence2;
        }
        catch (IOException ioe) {
            throw new XPathException((Expression)this, (Throwable)ioe);
        }
        catch (PermissionDeniedException e) {
            throw new XPathException((Expression)this, (Throwable)e);
        }
        finally {
            if (compiled != null) {
                compiled.getContext().runCleanupTasks();
                if (cache) {
                    pool.returnCompiledXQuery(querySource, compiled);
                } else {
                    compiled.reset();
                }
            }
        }
    }

    private Source loadQueryFromURI(Item expr) throws XPathException, NullPointerException, IllegalArgumentException {
        Source querySource;
        block16: {
            String location = expr.getStringValue();
            querySource = null;
            if (location.indexOf(58) < 0 || location.startsWith("xmldb:")) {
                try {
                    XmldbURI locationUri = XmldbURI.xmldbUriFor(location);
                    if (location.indexOf("/") < 0 || location.startsWith(".")) {
                        XmldbURI moduleLoadPathUri = XmldbURI.xmldbUriFor(this.context.getModuleLoadPath());
                        locationUri = moduleLoadPathUri.resolveCollectionPath(locationUri);
                    }
                    DocumentImpl sourceDoc = null;
                    try {
                        sourceDoc = this.context.getBroker().getXMLResource(locationUri.toCollectionPathURI(), Lock.LockMode.READ_LOCK);
                        if (sourceDoc == null) {
                            throw new XPathException((Expression)this, "source for module " + location + " not found in database");
                        }
                        if (sourceDoc.getResourceType() != 1 || !"application/xquery".equals(sourceDoc.getMetadata().getMimeType())) {
                            throw new XPathException((Expression)this, "source for module " + location + " is not an XQuery or declares a wrong mime-type");
                        }
                        querySource = new DBSource(this.context.getBroker(), (BinaryDocument)sourceDoc, true);
                        break block16;
                    }
                    catch (PermissionDeniedException e) {
                        throw new XPathException((Expression)this, "permission denied to read module source from " + location);
                    }
                    finally {
                        if (sourceDoc != null) {
                            sourceDoc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                        }
                    }
                }
                catch (URISyntaxException e) {
                    throw new XPathException((Expression)this, (Throwable)e);
                }
            }
            try {
                querySource = SourceFactory.getSource(this.context.getBroker(), this.context.getModuleLoadPath(), location, true);
            }
            catch (MalformedURLException e) {
                throw new XPathException((Expression)this, "source location for query at " + location + " should be a valid URL: " + e.getMessage());
            }
            catch (IOException e) {
                throw new XPathException((Expression)this, "source for query at " + location + " not found: " + e.getMessage());
            }
            catch (PermissionDeniedException e) {
                throw new XPathException((Expression)this, "Permission denied to access query at " + location + " : " + e.getMessage());
            }
        }
        return querySource;
    }

    private Sequence initContext(Node root, XQueryContext innerContext) throws XPathException {
        NodeList cl = root.getChildNodes();
        Sequence result = null;
        for (int i = 0; i < cl.getLength(); ++i) {
            Element elem;
            Node child = cl.item(i);
            if (child.getNodeType() == 1 && "variable".equals(child.getLocalName())) {
                NodeValue value;
                elem = (Element)child;
                String qname = elem.getAttribute("name");
                String source = elem.getAttribute("source");
                if (source != null && source.length() > 0) {
                    value = this.loadVarFromURI(source);
                } else {
                    value = (NodeValue)((Object)elem.getFirstChild());
                    if (value instanceof ReferenceNode) {
                        value = ((ReferenceNode)value).getReference();
                    }
                }
                String type = elem.getAttribute("type");
                if (type != null && Type.subTypeOf(Type.getType(type), 20)) {
                    innerContext.declareVariable(qname, (Object)value.atomize().convertTo(Type.getType(type)));
                    continue;
                }
                innerContext.declareVariable(qname, (Object)value);
                continue;
            }
            if (child.getNodeType() == 1 && "output-size-limit".equals(child.getLocalName())) {
                elem = (Element)child;
                innerContext.getWatchDog().setMaxNodes(Integer.parseInt(elem.getAttribute("value")));
                continue;
            }
            if (child.getNodeType() == 1 && "current-dateTime".equals(child.getLocalName())) {
                elem = (Element)child;
                DateTimeValue dtv = new DateTimeValue(elem.getAttribute("value"));
                innerContext.setCalendar(dtv.calendar);
                continue;
            }
            if (child.getNodeType() == 1 && "implicit-timezone".equals(child.getLocalName())) {
                elem = (Element)child;
                Duration duration = TimeUtils.getInstance().newDuration(elem.getAttribute("value"));
                innerContext.setTimeZone(new SimpleTimeZone((int)duration.getTimeInMillis(new Date()), "XQuery context"));
                continue;
            }
            if (child.getNodeType() == 1 && "unbind-namespace".equals(child.getLocalName())) {
                elem = (Element)child;
                if (elem.getAttribute("uri") == null) continue;
                innerContext.removeNamespace(elem.getAttribute("uri"));
                continue;
            }
            if (child.getNodeType() == 1 && "staticallyKnownDocuments".equals(child.getLocalName())) {
                elem = (Element)child;
                NodeValue value = (NodeValue)((Object)elem.getFirstChild());
                if (value instanceof ReferenceNode) {
                    value = ((ReferenceNode)value).getReference();
                }
                XmldbURI[] pathes = new XmldbURI[]{XmldbURI.create(value.getStringValue())};
                innerContext.setStaticallyKnownDocuments(pathes);
                continue;
            }
            if (child.getNodeType() != 1 || !"default-context".equals(child.getLocalName())) continue;
            elem = (Element)child;
            NodeValue nodevalue = (NodeValue)((Object)elem);
            result = nodevalue.toSequence();
        }
        return result;
    }

    private NodeImpl loadVarFromURI(String uri) throws XPathException {
        try {
            URL url = new URL(uri);
            InputStreamReader isr = new InputStreamReader(url.openStream(), "UTF-8");
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            InputSource src = new InputSource(isr);
            SAXParser parser = factory.newSAXParser();
            XMLReader xr = parser.getXMLReader();
            SAXAdapter adapter = new SAXAdapter(this.context);
            xr.setContentHandler(adapter);
            xr.setProperty("http://xml.org/sax/properties/lexical-handler", adapter);
            xr.parse(src);
            isr.close();
            return adapter.getDocument();
        }
        catch (MalformedURLException e) {
            throw new XPathException((Expression)this, (Throwable)e);
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, (Throwable)e);
        }
        catch (SAXException e) {
            throw new XPathException((Expression)this, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new XPathException((Expression)this, (Throwable)e);
        }
    }

    private class CallableEval
    implements Callable<Sequence> {
        private final XQueryContext callersContext;
        private final Sequence contextSequence;
        private final Sequence[] args;
        private final Subject subject;

        public CallableEval(XQueryContext context, Sequence contextSequence, Sequence[] args) {
            this.callersContext = context;
            this.contextSequence = contextSequence;
            this.args = args;
            this.subject = this.callersContext.getSubject();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Sequence call() throws XPathException {
            BrokerPool db = null;
            try {
                db = BrokerPool.getInstance();
                XQueryContext context = this.callersContext.copyContext();
                try (DBBroker broker = db.get(Optional.ofNullable(this.subject));){
                    Sequence sequence = Eval.this.doEval(context, this.contextSequence, this.args);
                    return sequence;
                }
            }
            catch (EXistException ex) {
                throw new XPathException("Unable to get new broker: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

