/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.ExtArrayNodeSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.numbering.NodeId;
import org.exist.security.PermissionDeniedException;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;

public class FunDoctype
extends Function {
    protected static final Logger logger = LogManager.getLogger(FunDoctype.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("doctype", "http://exist-db.org/xquery/util", "util"), "Returns the document nodes of the documents with the given DOCTYPE(s).", new SequenceType[]{new FunctionParameterSequenceType("doctype", 22, 6, "The DOCTYPE of the documents to find")}, (SequenceType)new FunctionReturnSequenceType(-1, 7, "the document nodes"), true);

    public FunDoctype(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        DefaultDocumentSet docs = new DefaultDocumentSet();
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            Sequence seq = this.getArgument(i).eval(contextSequence, contextItem);
            SequenceIterator j = seq.iterate();
            while (j.hasNext()) {
                String next = j.nextItem().getStringValue();
                try {
                    this.context.getBroker().getXMLResourcesByDoctype(next, docs);
                }
                catch (PermissionDeniedException pde) {
                    LOG.error(pde.getMessage(), (Throwable)pde);
                    throw new XPathException(pde);
                }
            }
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet(1);
        Iterator<DocumentImpl> i = docs.getDocumentIterator();
        while (i.hasNext()) {
            result.add(new NodeProxy(i.next(), NodeId.DOCUMENT_NODE));
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

