/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FunUnEscapeURI
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(FunUnEscapeURI.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("unescape-uri", "http://exist-db.org/xquery/util", "util"), "Returns an un-escaped URL escaped string with the encoding scheme (e.g. \"UTF-8\"). Decodes encoded sensitive characters from a URL, for example \"%2F\" becomes \"/\", i.e. does the oposite to escape-uri()", new SequenceType[]{new FunctionParameterSequenceType("escaped-string", 22, 2, "The escaped string to be un-escaped"), new FunctionParameterSequenceType("encoding", 22, 2, "The encoding scheme to use in the un-escaping of the string")}, new FunctionParameterSequenceType("result", 22, 2, "the un-escaped string"));

    public FunUnEscapeURI(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        try {
            return new StringValue(URLDecoder.decode(args[0].getStringValue(), args[1].getStringValue()));
        }
        catch (UnsupportedEncodingException e) {
            throw new XPathException((Expression)this, "Unsupported Encoding Scheme: " + e.getMessage(), (Throwable)e);
        }
    }
}

