/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.StoredNode;
import org.exist.stax.IEmbeddedXMLStreamReader;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetFragmentBetween
extends Function {
    protected static final Logger logger = LogManager.getLogger(GetFragmentBetween.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-fragment-between", "http://exist-db.org/xquery/util", "util"), "Returns an xml fragment or a sequence of nodes between two elements (normally milestone elements). This function works only on documents which are stored in eXist DB.The $beginning-node represents the first node/milestone element, $ending-node, the second one. The third argument, $make-fragment, is a boolean value for the path completion. If it is set to true() the result sequence is wrapped into a parent element node. The fourth argument, display-root-namespace, is a boolean value for displaying the root node namespace. If it is set to true() the attribute \"xmlns\" in the root node of the result sequence is determined explicitely from the $beginning-node. Example call of the function for getting the fragment between two TEI page break element nodes:   let $fragment := util:get-fragment-between(//pb[1], //pb[2], true(), true())", new SequenceType[]{new FunctionParameterSequenceType("beginning-node", -1, 3, "The first node/milestone element"), new FunctionParameterSequenceType("ending-node", -1, 3, "The second node/milestone element"), new FunctionParameterSequenceType("make-fragment", 23, 3, "The flag make a fragment."), new FunctionParameterSequenceType("display-root-namespace", 23, 3, "Display the namespace of the root node of the fragment.")}, (SequenceType)new FunctionReturnSequenceType(22, 2, "the string containing the fragment between the two node/milestone elements."), true);
    private static final String regExpr = "[a-zA-Z0-9:]+?\\[.+?\\]/|[a-zA-Z0-9:]+?/|[a-zA-Z0-9:]+?\\[.+\\]$|[a-zA-Z0-9:]+?$";
    private static final Pattern p = Pattern.compile("[a-zA-Z0-9:]+?\\[.+?\\]/|[a-zA-Z0-9:]+?/|[a-zA-Z0-9:]+?\\[.+\\]$|[a-zA-Z0-9:]+?$", 10);

    public GetFragmentBetween(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        int argumentCount = this.getArgumentCount();
        if (argumentCount < 2) {
            logger.error("requires at least 2 arguments");
            throw new XPathException((Expression)this, "requires at least 2 arguments");
        }
        Sequence ms1 = this.getArgument(0).eval(contextSequence, contextItem);
        Sequence ms2 = this.getArgument(1).eval(contextSequence, contextItem);
        if (ms1.isEmpty()) {
            throw new XPathException((Expression)this, "your first argument delivers an empty node (no valid node position in document)");
        }
        Node ms1Node = null;
        if (ms1.itemAt(0) != null) {
            ms1Node = ((NodeValue)ms1.itemAt(0)).getNode();
        }
        Node ms2Node = null;
        if (ms2.itemAt(0) != null) {
            ms2Node = ((NodeValue)ms2.itemAt(0)).getNode();
        }
        boolean pathCompletion = true;
        if (argumentCount > 2) {
            Sequence seqPathCompletion = this.getArgument(2).eval(contextSequence, contextItem);
            pathCompletion = seqPathCompletion.effectiveBooleanValue();
        }
        boolean displayRootNamespace = false;
        if (argumentCount > 3) {
            Sequence seqDisplayRootNamespace = this.getArgument(3).eval(contextSequence, contextItem);
            displayRootNamespace = seqDisplayRootNamespace.effectiveBooleanValue();
        }
        StringBuilder fragment = this.getFragmentBetween(ms1Node, ms2Node);
        if (pathCompletion) {
            String msFromPathName = this.getNodeXPath(ms1Node.getParentNode(), displayRootNamespace);
            String openElementsOfMsFrom = this.pathName2XmlTags(msFromPathName, "open");
            String closingElementsOfMsTo = "";
            if (ms2Node != null) {
                String msToPathName = this.getNodeXPath(ms2Node.getParentNode(), displayRootNamespace);
                closingElementsOfMsTo = this.pathName2XmlTags(msToPathName, "close");
            }
            fragment.insert(0, openElementsOfMsFrom);
            fragment.append(closingElementsOfMsTo);
        }
        StringValue strValFragment = new StringValue(fragment.toString());
        ValueSequence resultFragment = new ValueSequence();
        resultFragment.add(strValFragment);
        return resultFragment;
    }

    private StringBuilder getFragmentBetween(Node node1, Node node2) throws XPathException {
        StoredNode storedNode1 = (StoredNode)node1;
        StoredNode storedNode2 = (StoredNode)node2;
        String node1NodeId = storedNode1.getNodeId().toString();
        String node2NodeId = "-1";
        if (node2 != null) {
            node2NodeId = storedNode2.getNodeId().toString();
        }
        DocumentImpl docImpl = (DocumentImpl)node1.getOwnerDocument();
        StringBuilder resultFragment = new StringBuilder();
        String actualNodeId = "-2";
        boolean getFragmentMode = false;
        try {
            BrokerPool brokerPool = docImpl.getBrokerPool();
            try (DBBroker dbBroker = brokerPool.getBroker();){
                IEmbeddedXMLStreamReader reader = null;
                NodeList children = docImpl.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    StoredNode docChildStoredNode = (StoredNode)children.item(i);
                    short docChildStoredNodeType = docChildStoredNode.getNodeType();
                    reader = dbBroker.getXMLStreamReader(docChildStoredNode, false);
                    while (reader.hasNext() && !node2NodeId.equals(actualNodeId) && docChildStoredNodeType != 7 && docChildStoredNodeType != 8) {
                        int status = reader.next();
                        switch (status) {
                            case 7: 
                            case 8: {
                                break;
                            }
                            case 1: {
                                actualNodeId = reader.getNode().getNodeId().toString();
                                if (actualNodeId.equals(node1NodeId)) {
                                    getFragmentMode = true;
                                }
                                if (actualNodeId.equals(node2NodeId)) {
                                    getFragmentMode = false;
                                }
                                if (!getFragmentMode) break;
                                String startElementTag = this.getStartElementTag(reader);
                                resultFragment.append(startElementTag);
                                break;
                            }
                            case 2: {
                                if (!getFragmentMode) break;
                                String endElementTag = this.getEndElementTag(reader);
                                resultFragment.append(endElementTag);
                                break;
                            }
                            case 4: {
                                if (!getFragmentMode) break;
                                String characters = this.getCharacters(reader);
                                resultFragment.append(characters);
                                break;
                            }
                            case 12: {
                                if (!getFragmentMode) break;
                                String cdata = this.getCDataTag(reader);
                                resultFragment.append(cdata);
                                break;
                            }
                            case 5: {
                                if (!getFragmentMode) break;
                                String comment = this.getCommentTag(reader);
                                resultFragment.append(comment);
                                break;
                            }
                            case 3: {
                                if (!getFragmentMode) break;
                                String piTag = this.getPITag(reader);
                                resultFragment.append(piTag);
                            }
                        }
                    }
                }
            }
        }
        catch (EXistException e) {
            throw new XPathException((Expression)this, "An error occurred while getFragmentBetween: " + e.getMessage(), (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new XPathException((Expression)this, "An error occurred while getFragmentBetween: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, "An error occurred while getFragmentBetween: " + e.getMessage(), (Throwable)e);
        }
        return resultFragment;
    }

    private String getStartElementTag(XMLStreamReader reader) {
        String elemName = reader.getLocalName();
        int nsCount = reader.getNamespaceCount();
        StringBuilder elemNsString = new StringBuilder();
        for (int ni = 0; ni < nsCount; ++ni) {
            String nsPrefix = reader.getNamespacePrefix(ni);
            String nsUri = reader.getNamespaceURI(ni);
            String nsString = "xmlns:" + nsPrefix + "=\"" + nsUri + "\"";
            if (nsPrefix != null && "".equals(nsPrefix)) {
                nsString = "xmlns=\"" + nsUri + "\"";
            }
            elemNsString.append(" ").append(nsString);
        }
        int attrCount = reader.getAttributeCount();
        StringBuilder elemAttrString = new StringBuilder();
        for (int j = 0; j < attrCount; ++j) {
            String attrNamePrefix = reader.getAttributePrefix(j);
            String attrName = reader.getAttributeLocalName(j);
            String attrValue = reader.getAttributeValue(j);
            attrValue = this.escape(attrValue);
            String attrString = "";
            if (attrNamePrefix != null && attrNamePrefix.length() != 0) {
                attrString = attrNamePrefix + ":";
            }
            attrString = attrString + attrName + "=\"" + attrValue + "\"";
            elemAttrString.append(" ").append(attrString);
        }
        String elemPrefix = reader.getPrefix();
        String elemPart = "";
        if (elemPrefix != null && elemPrefix.length() != 0) {
            elemPart = elemPrefix + ":";
        }
        elemPart = elemPart + elemName;
        String elementString = "<" + elemPart + elemNsString.toString() + elemAttrString.toString() + ">";
        return elementString;
    }

    private String getEndElementTag(XMLStreamReader reader) {
        String elemName = reader.getLocalName();
        String elemPrefix = reader.getPrefix();
        String elemPart = "";
        if (elemPrefix != null && elemPrefix.length() != 0) {
            elemPart = elemPrefix + ":";
        }
        elemPart = elemPart + elemName;
        return "</" + elemPart + ">";
    }

    private String getCharacters(XMLStreamReader reader) {
        String xmlChars = reader.getText();
        xmlChars = this.escape(xmlChars);
        return xmlChars;
    }

    private String getCDataTag(XMLStreamReader reader) {
        char[] chars = reader.getTextCharacters();
        return "<![CDATA[\n" + new String(chars) + "\n]]>";
    }

    private String getCommentTag(XMLStreamReader reader) {
        char[] chars = reader.getTextCharacters();
        return "<!--" + new String(chars) + "-->";
    }

    private String getPITag(XMLStreamReader reader) {
        String piTarget = reader.getPITarget();
        String piData = reader.getPIData();
        piData = piData != null && piData.length() != 0 ? " " + piData : "";
        return "<?" + piTarget + piData + "?>";
    }

    private String escape(String inputStr) {
        StringBuilder resultStrBuf = new StringBuilder();
        block7: for (int i = 0; i < inputStr.length(); ++i) {
            char ch = inputStr.charAt(i);
            switch (ch) {
                case '<': {
                    resultStrBuf.append("&lt;");
                    continue block7;
                }
                case '>': {
                    resultStrBuf.append("&gt;");
                    continue block7;
                }
                case '&': {
                    resultStrBuf.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    resultStrBuf.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    resultStrBuf.append("&#039;");
                    continue block7;
                }
                default: {
                    resultStrBuf.append(ch);
                }
            }
        }
        return resultStrBuf.toString();
    }

    private String pathName2XmlTags(String pathName, String mode) {
        String result;
        block3: {
            List<String> elements;
            block2: {
                result = "";
                elements = this.pathName2ElementsWithAttributes(pathName);
                if (!"open".equals(mode)) break block2;
                for (String element : elements) {
                    element = element.replaceAll("\\[", " ");
                    element = element.replaceAll(" eq ", "=");
                    element = element.replaceAll("@", "");
                    if ((element = element.replaceAll("\\]", "")).length() == 0) continue;
                    result = result + "<" + element + ">\n";
                }
                break block3;
            }
            if (!"close".equals(mode)) break block3;
            for (int i = elements.size() - 1; i >= 0; --i) {
                String element = elements.get(i);
                if ((element = element.replaceAll("\\[[^\\]]*\\]", "")).length() == 0) continue;
                result = result + "</" + element + ">\n";
            }
        }
        return result;
    }

    private List<String> pathName2ElementsWithAttributes(String pathName) {
        ArrayList<String> result = new ArrayList<String>();
        if (pathName.charAt(0) == '/') {
            pathName = pathName.substring(1, pathName.length());
        }
        Matcher m = p.matcher(pathName);
        while (m.find()) {
            int msEndPos;
            int msBeginPos = m.start();
            String elementName = pathName.substring(msBeginPos, msEndPos = m.end());
            int elemNameSize = elementName.length();
            if (elemNameSize > 0 && elementName.charAt(elemNameSize - 1) == '/') {
                elementName = elementName.substring(0, elemNameSize - 1);
            }
            result.add(elementName);
        }
        return result;
    }

    private String getNodeXPath(Node n, boolean setRootNamespace) {
        if (n.getNodeType() == 9) {
            return "/";
        }
        StringBuilder buf = new StringBuilder(this.nodeToXPath(n, setRootNamespace));
        while ((n = n.getParentNode()) != null) {
            if (n.getNodeType() != 1) continue;
            buf.insert(0, this.nodeToXPath(n, setRootNamespace));
        }
        return buf.toString();
    }

    private StringBuilder nodeToXPath(Node n, boolean setRootNamespace) {
        String nsUri;
        Node parentNode;
        short parentNodeType;
        StringBuilder xpath = new StringBuilder("/" + this.getFullNodeName(n));
        if (setRootNamespace && (parentNodeType = (parentNode = n.getParentNode()).getNodeType()) == 9 && (nsUri = n.getNamespaceURI()) != null) {
            xpath.append("[@xmlns eq \"").append(nsUri).append("\"]");
        }
        NamedNodeMap attrs = n.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String fullNodeName = this.getFullNodeName(attr);
            String attrNodeValue = attr.getNodeValue();
            if ("".equals(fullNodeName) || fullNodeName == null) continue;
            xpath.append("[@").append(fullNodeName).append(" eq \"").append(attrNodeValue).append("\"]");
        }
        return xpath;
    }

    private String getFullNodeName(Node n) {
        String prefix = n.getPrefix();
        String localName = n.getLocalName();
        if (prefix == null || "".equals(prefix)) {
            if (localName == null || localName.isEmpty()) {
                return "";
            }
            return localName;
        }
        if (localName == null || localName.isEmpty()) {
            return "";
        }
        return prefix + ":" + localName;
    }
}

