/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.security.MessageDigester;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class Hash
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(Hash.class);
    private static final FunctionParameterSequenceType message = new FunctionParameterSequenceType("message", 11, 2, "The string to generate the hashcode from");
    private static final FunctionParameterSequenceType algorithm = new FunctionParameterSequenceType("algorithm", 22, 2, "The algorithm used to generate the hashcode");
    private static final FunctionParameterSequenceType base64flag = new FunctionParameterSequenceType("base64flag", 23, 2, "The flag that specifies whether to return the result as Base64 encoded");
    private static final FunctionReturnSequenceType result = new FunctionReturnSequenceType(22, 2, "the hashcode");
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("hash", "http://exist-db.org/xquery/util", "util"), "Calculates a hashcode from a string based on a specified algorithm.", new SequenceType[]{message, algorithm}, result), new FunctionSignature(new QName("hash", "http://exist-db.org/xquery/util", "util"), "Calculates a hashcode from a string based on a specified algorithm.", new SequenceType[]{message, algorithm, base64flag}, result)};

    public Hash(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        boolean base64 = false;
        String message = args[0].itemAt(0).getStringValue();
        String algorithm = args[1].itemAt(0).getStringValue();
        if (args.length > 2) {
            base64 = args[2].effectiveBooleanValue();
        }
        String md = null;
        try {
            md = MessageDigester.calculate(message, algorithm, base64);
        }
        catch (IllegalArgumentException ex) {
            throw new XPathException(ex.getMessage());
        }
        return new StringValue(md);
    }
}

