/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.NodeSet;
import org.exist.indexing.IndexWorker;
import org.exist.indexing.OrderedValuesIndex;
import org.exist.storage.Indexable;
import org.exist.util.Occurrences;
import org.exist.util.ValueOccurrences;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class IndexKeyOccurrences
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(IndexKeyOccurrences.class);
    protected static final FunctionParameterSequenceType nodeParam = new FunctionParameterSequenceType("nodes", -1, 7, "The nodes whose content is indexed");
    protected static final FunctionParameterSequenceType valueParam = new FunctionParameterSequenceType("value", 20, 2, "The indexed value to search for");
    protected static final FunctionParameterSequenceType indexParam = new FunctionParameterSequenceType("index", 22, 2, "The index in which the search is made");
    protected static final FunctionReturnSequenceType result = new FunctionReturnSequenceType(31, 3, "the number of occurrences for the indexed value");
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("index-key-occurrences", "http://exist-db.org/xquery/util", "util"), "Return the number of occurrences for an indexed value.", new SequenceType[]{nodeParam, valueParam}, result), new FunctionSignature(new QName("index-key-occurrences", "http://exist-db.org/xquery/util", "util"), "Return the number of occurrences for an indexed value.", new SequenceType[]{nodeParam, valueParam, indexParam}, result)};

    public IndexKeyOccurrences(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        if (args[0].isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            NodeSet nodes = args[0].toNodeSet();
            DocumentSet docs = nodes.getDocumentSet();
            if (this.getArgumentCount() == 3) {
                IndexWorker indexWorker = this.context.getBroker().getIndexController().getWorkerByIndexName(args[2].itemAt(0).getStringValue());
                if (indexWorker == null) {
                    throw new XPathException((Expression)this, "Unknown index: " + args[2].itemAt(0).getStringValue());
                }
                HashMap<String, Sequence> hints = new HashMap<String, Sequence>();
                if (indexWorker instanceof OrderedValuesIndex) {
                    hints.put("start_value", args[1]);
                } else {
                    logger.warn(indexWorker.getClass().getName() + " isn't an instance of org.exist.indexing.OrderedIndexWorker. Start value '" + args[1] + "' ignored.");
                }
                Occurrences[] occur = indexWorker.scanIndex(this.context, docs, nodes, hints);
                result = occur.length == 0 ? Sequence.EMPTY_SEQUENCE : new IntegerValue(occur[0].getOccurrences());
            } else {
                ValueOccurrences[] occur = this.context.getBroker().getValueIndex().scanIndexKeys(docs, nodes, (Indexable)((Object)args[1].itemAt(0)));
                if (occur.length == 0) {
                    occur = this.context.getBroker().getValueIndex().scanIndexKeys(docs, nodes, null, (Indexable)((Object)args[1].itemAt(0)));
                }
                result = occur.length == 0 ? Sequence.EMPTY_SEQUENCE : new IntegerValue(occur[0].getOccurrences());
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

