/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.source.StringSource;
import org.exist.storage.serializers.Serializer;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.xml.sax.SAXException;

public class LogFunction
extends BasicFunction {
    protected static final FunctionParameterSequenceType PRIORITY_PARAMETER = new FunctionParameterSequenceType("priority", 22, 2, "The logging priority: 'error', 'warn', 'debug', 'info', 'trace'");
    protected static final FunctionParameterSequenceType LOGGER_NAME_PARAMETER = new FunctionParameterSequenceType("logger-name", 22, 2, "The name of the logger, eg: my.app.log");
    protected static final FunctionParameterSequenceType MESSAGE_PARAMETER = new FunctionParameterSequenceType("message", 11, 7, "The message to log");
    protected static final Logger logger = LogManager.getLogger(LogFunction.class);
    public static final String FUNCTION_LOG = "log";
    public static final String FUNCTION_LOGAPP = "log-app";
    public static final String FUNCTION_LOG_SYSTEM_OUT = "log-system-out";
    public static final String FUNCTION_LOG_SYSTEM_ERR = "log-system-err";
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("log", "http://exist-db.org/xquery/util", "util"), "Logs the message to the current logger.", new SequenceType[]{PRIORITY_PARAMETER, MESSAGE_PARAMETER}, new SequenceType(11, 1)), new FunctionSignature(new QName("log-system-out", "http://exist-db.org/xquery/util", "util"), "Logs the message to System.out.", new SequenceType[]{MESSAGE_PARAMETER}, new SequenceType(11, 1)), new FunctionSignature(new QName("log-system-err", "http://exist-db.org/xquery/util", "util"), "Logs the message to System.err.", new SequenceType[]{MESSAGE_PARAMETER}, new SequenceType(11, 1)), new FunctionSignature(new QName("log-app", "http://exist-db.org/xquery/util", "util"), "Logs the message to the named logger", new SequenceType[]{PRIORITY_PARAMETER, LOGGER_NAME_PARAMETER, MESSAGE_PARAMETER}, new SequenceType(11, 1))};

    public LogFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        SequenceIterator i;
        String calledAs;
        switch (calledAs = this.getName().getLocalPart()) {
            case "log": {
                i = args[1].unorderedIterator();
                if (!args[1].isEmpty()) break;
                return Sequence.EMPTY_SEQUENCE;
            }
            case "log-app": {
                i = args[2].unorderedIterator();
                if (!args[2].isEmpty()) break;
                return Sequence.EMPTY_SEQUENCE;
            }
            default: {
                i = args[0].unorderedIterator();
                if (!args[0].isEmpty()) break;
                return Sequence.EMPTY_SEQUENCE;
            }
        }
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        buf.append("Line: ");
        buf.append(this.getLine());
        if (this.getSource() != null && this.getSource().getKey() != null) {
            buf.append(" ");
            if (this.getSource() instanceof StringSource) {
                buf.append(this.getSource().type());
            } else {
                buf.append(this.getSource().getKey());
            }
        }
        buf.append(") ");
        while (i.hasNext()) {
            Item next = i.nextItem();
            if (Type.subTypeOf(next.getType(), -1)) {
                Serializer serializer = this.context.getBroker().getSerializer();
                serializer.reset();
                try {
                    buf.append(serializer.serialize((NodeValue)next));
                    continue;
                }
                catch (SAXException e) {
                    throw new XPathException((Expression)this, "An exception occurred while serializing node to log: " + e.getMessage(), (Throwable)e);
                }
            }
            buf.append(next.getStringValue());
        }
        switch (calledAs) {
            case "log": {
                String loglevel = args[0].getStringValue().toLowerCase();
                this.writeLog(buf, loglevel, logger);
                break;
            }
            case "log-system-out": {
                System.out.println(buf);
                break;
            }
            case "log-system-err": {
                System.err.println(buf);
                break;
            }
            case "log-app": {
                String loglevelapp = args[0].getStringValue().toLowerCase();
                String logname = args[1].getStringValue();
                Logger logger = logname == null || logname.isEmpty() ? LOG : LogManager.getLogger((String)logname);
                this.writeLog(buf, loglevelapp, logger);
                break;
            }
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    private void writeLog(StringBuilder buffer, String loglevel, Logger logger) {
        switch (loglevel) {
            case "error": {
                logger.error((CharSequence)buffer);
                break;
            }
            case "warn": {
                logger.warn((CharSequence)buffer);
                break;
            }
            case "info": {
                logger.info((CharSequence)buffer);
                break;
            }
            case "trace": {
                logger.trace((CharSequence)buffer);
                break;
            }
            default: {
                logger.debug((CharSequence)buffer);
            }
        }
    }
}

