/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NodeXPath
extends Function {
    protected static final Logger logger = LogManager.getLogger(NodeXPath.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("node-xpath", "http://exist-db.org/xquery/util", "util"), "Returns the XPath for a Node.", new SequenceType[]{new FunctionParameterSequenceType("node", -1, 2, "The node to retrieve the XPath to")}, new FunctionReturnSequenceType(22, 3, "the XPath expression of the node"));

    public NodeXPath(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence seq = this.getArgument(0).eval(contextSequence, contextItem);
        if (seq.isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        NodeValue nv = (NodeValue)seq.itemAt(0);
        Node n = nv.getNode();
        if (n.getNodeType() == 9) {
            return new StringValue("/");
        }
        StringBuilder buf = new StringBuilder(this.nodeToXPath(n));
        while ((n = n.getParentNode()) != null) {
            if (n.getNodeType() != 1) continue;
            buf.insert(0, this.nodeToXPath(n));
        }
        return new StringValue(buf.toString());
    }

    public StringBuilder nodeToXPath(Node n) {
        StringBuilder xpath = new StringBuilder("/" + this.getFullNodeName(n));
        NamedNodeMap attrs = n.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            xpath.append("[@").append(this.getFullNodeName(attr)).append(" eq \"").append(attr.getNodeValue()).append("\"]");
        }
        return xpath;
    }

    public String getFullNodeName(Node n) {
        return n.getPrefix() != null && !"".equals(n.getPrefix()) ? n.getPrefix() + ":" + n.getLocalName() : n.getLocalName();
    }
}

