/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import com.evolvedbinary.j8fu.Either;
import java.io.IOException;
import java.io.StringReader;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.memtree.SAXAdapter;
import org.exist.util.HtmlToXmlParser;
import org.exist.validation.ValidationReport;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.validation.Shared;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Parse
extends BasicFunction {
    private static final FunctionReturnSequenceType RESULT_TYPE = new FunctionReturnSequenceType(6, 3, "the XML fragment parsed from the string");
    private static final FunctionParameterSequenceType TO_BE_PARSED_PARAMETER = new FunctionParameterSequenceType("to-be-parsed", 22, 3, "The string to be parsed");
    private static final Logger logger = LogManager.getLogger(Parse.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("parse", "http://exist-db.org/xquery/util", "util"), "Parses the passed string value into an XML fragment. The string has to be well-formed XML. An empty sequence is returned if the argument is an empty string or sequence. If the XML is not well-formed, the function throws an error (EXXQDY0002). An XML-formatted description of the error is contained in the error value and can be accessed using XQuery 3.0 try-catch statement.", new SequenceType[]{TO_BE_PARSED_PARAMETER}, RESULT_TYPE), new FunctionSignature(new QName("parse-html", "http://exist-db.org/xquery/util", "util"), "Parses the passed string value into an XML fragment. The HTML string may not be well-formed XML. It will be passed through the Neko HTML parser to make it well-formed. An empty sequence is returned if the argument is an empty string or sequence.", new SequenceType[]{TO_BE_PARSED_PARAMETER}, RESULT_TYPE)};

    public Parse(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].getItemCount() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String xmlContent = args[0].itemAt(0).getStringValue();
        if (xmlContent.length() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        StringReader reader = new StringReader(xmlContent);
        ValidationReport report = new ValidationReport();
        SAXAdapter adapter = new SAXAdapter(this.context);
        try {
            XMLReader xr;
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            InputSource src = new InputSource(reader);
            if (this.isCalledAs("parse-html")) {
                Optional<Either<Throwable, XMLReader>> maybeReaderInst = HtmlToXmlParser.getHtmlToXmlParser(this.context.getBroker().getConfiguration());
                if (!maybeReaderInst.isPresent()) throw new XPathException((Expression)this, ErrorCodes.EXXQDY0002, "There is no HTML to XML parser configured in conf.xml");
                Either<Throwable, XMLReader> readerInst = maybeReaderInst.get();
                if (readerInst.isLeft()) {
                    String msg = "Unable to parse HTML to XML please ensure the parser is configured in conf.xml and is present on the classpath";
                    Throwable t = (Throwable)readerInst.left().get();
                    LOG.error("Unable to parse HTML to XML please ensure the parser is configured in conf.xml and is present on the classpath", t);
                    throw new XPathException((Expression)this, ErrorCodes.EXXQDY0002, t);
                }
                xr = (XMLReader)readerInst.right().get();
            } else {
                SAXParser parser = factory.newSAXParser();
                xr = parser.getXMLReader();
            }
            xr.setErrorHandler(report);
            xr.setContentHandler(adapter);
            xr.setProperty("http://xml.org/sax/properties/lexical-handler", adapter);
            xr.parse(src);
        }
        catch (ParserConfigurationException e) {
            throw new XPathException(this, ErrorCodes.EXXQDY0002, "Error while constructing XML parser: " + e.getMessage(), args[0], e);
        }
        catch (SAXException e) {
            logger.debug("Error while parsing XML: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XPathException(this, ErrorCodes.EXXQDY0002, "Error while parsing XML: " + e.getMessage(), args[0], e);
        }
        if (report.isValid()) {
            return adapter.getDocument();
        }
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        NodeImpl result = Shared.writeReport(report, builder);
        throw new XPathException(this, ErrorCodes.EXXQDY0002, report.toString(), result);
    }
}

