/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExternalModule;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Module;
import org.exist.xquery.Option;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class PrologFunctions
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(PrologFunctions.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("import-module", "http://exist-db.org/xquery/util", "util"), "Dynamically imports an XQuery module into the current context. The parameters have the same meaning as in an 'import module ...' expression in the query prolog.", new SequenceType[]{new FunctionParameterSequenceType("module-uri", 25, 2, "The namespace URI of the module"), new FunctionParameterSequenceType("prefix", 22, 2, "The prefix to be assigned to the namespace"), new FunctionParameterSequenceType("location", 25, 2, "The location of the module")}, new SequenceType(11, 1)), new FunctionSignature(new QName("declare-namespace", "http://exist-db.org/xquery/util", "util"), "Dynamically declares a namespace/prefix mapping for the current context.", new SequenceType[]{new FunctionParameterSequenceType("prefix", 22, 2, "The prefix to be assigned to the namespace"), new FunctionParameterSequenceType("namespace-uri", 25, 2, "The namespace URI")}, new SequenceType(11, 1)), new FunctionSignature(new QName("declare-option", "http://exist-db.org/xquery/util", "util"), "Dynamically declares a serialization option as with 'declare option'.", new SequenceType[]{new FunctionParameterSequenceType("name", 22, 2, "The serialization option name"), new FunctionParameterSequenceType("option", 22, 2, "The serialization option value")}, new SequenceType(11, 1)), new FunctionSignature(new QName("get-option", "http://exist-db.org/xquery/util", "util"), "Gets the value of a serialization option as set with 'declare option'.", new SequenceType[]{new FunctionParameterSequenceType("name", 22, 2, "The serialization option name")}, new SequenceType(22, 3))};

    public PrologFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.isCalledAs("declare-namespace")) {
            this.declareNamespace(args);
        } else if (this.isCalledAs("declare-option")) {
            this.declareOption(args);
        } else {
            if (this.isCalledAs("get-option")) {
                return this.getOption(args);
            }
            this.importModule(args);
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    private void declareNamespace(Sequence[] args) throws XPathException {
        this.context.saveState();
        String prefix = args[0].isEmpty() ? "" : args[0].getStringValue();
        String uri = args[1].getStringValue();
        this.context.declareNamespace(prefix, uri);
    }

    private void importModule(Sequence[] args) throws XPathException {
        this.context.saveState();
        String uri = args[0].getStringValue();
        String prefix = args[1].getStringValue();
        String location = args[2].getStringValue();
        Module module = this.context.importModule(uri, prefix, location);
        this.context.getRootContext().resolveForwardReferences();
        if (!module.isInternalModule()) {
            ((ExternalModule)module).getRootExpression().analyze(new AnalyzeContextInfo());
        }
    }

    private void declareOption(Sequence[] args) throws XPathException {
        String qname = args[0].getStringValue();
        String options = args[1].getStringValue();
        this.context.addDynamicOption(qname, options);
    }

    private Sequence getOption(Sequence[] args) throws XPathException {
        String qnameString = args[0].getStringValue();
        try {
            QName qname = QName.parse(this.context, qnameString, this.context.getDefaultFunctionNamespace());
            Option option = this.context.getOption(qname);
            if (option != null) {
                return new StringValue(option.getContents());
            }
            return Sequence.EMPTY_SEQUENCE;
        }
        catch (QName.IllegalQNameException e) {
            throw new XPathException((Expression)this, ErrorCodes.XPST0081, "No namespace defined for prefix " + qnameString);
        }
    }
}

