/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.validation;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.memtree.NodeImpl;
import org.exist.storage.BrokerPool;
import org.exist.util.Configuration;
import org.exist.validation.GrammarPool;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;
import org.xml.sax.helpers.AttributesImpl;

public class GrammarTooling
extends BasicFunction {
    private static final String TYPE_DTD = "http://www.w3.org/TR/REC-xml";
    private static final String TYPE_XSD = "http://www.w3.org/2001/XMLSchema";
    private final Configuration config;
    public static final String cacheReport = "<report>\n\t<grammar type=\"...\"\n\t\t<Namespace>....\n\t\t<BaseSystemId>...\n\t\t<LiteralSystemId>...\n\t\t<ExpandedSystemId>....\n\t</grammar>\n\t...\n\t...\n</report>\n";
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("clear-grammar-cache", "http://exist-db.org/xquery/validation", "validation"), "Remove all cached grammers.", null, new FunctionReturnSequenceType(31, 2, "the number of deleted grammars.")), new FunctionSignature(new QName("show-grammar-cache", "http://exist-db.org/xquery/validation", "validation"), "Show all cached grammars.", null, new FunctionReturnSequenceType(-1, 2, "an XML document containing details on all cached grammars.")), new FunctionSignature(new QName("pre-parse-grammar", "http://exist-db.org/xquery/validation", "validation"), "Pre parse grammars and add to grammar cache. Only XML schemas (.xsd) are supported.", new SequenceType[]{new FunctionParameterSequenceType("grammar", 25, 7, "Reference to grammar.")}, new FunctionReturnSequenceType(22, 7, "sequence of namespaces of preparsed grammars."))};

    public GrammarTooling(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
        BrokerPool brokerPool = context.getBroker().getBrokerPool();
        this.config = brokerPool.getConfiguration();
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        GrammarPool grammarpool = (GrammarPool)this.config.getProperty("validation.grammar_pool");
        if (this.isCalledAs("clear-grammar-cache")) {
            ValueSequence result = new ValueSequence();
            int before = this.countTotalNumberOfGrammar(grammarpool);
            LOG.debug("Clearing " + before + " grammars");
            this.clearGrammarPool(grammarpool);
            int after = this.countTotalNumberOfGrammar(grammarpool);
            LOG.debug("Remained " + after + " grammars");
            int delta = before - after;
            result.add(new IntegerValue(delta));
            return result;
        }
        if (this.isCalledAs("show-grammar-cache")) {
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            NodeImpl result = this.writeReport(grammarpool, builder);
            return result;
        }
        if (this.isCalledAs("pre-parse-grammar")) {
            if (args[0].isEmpty()) {
                return Sequence.EMPTY_SEQUENCE;
            }
            XMLGrammarPreparser parser = new XMLGrammarPreparser();
            parser.registerPreparser(TYPE_XSD, null);
            ArrayList<Grammar> allGrammars = new ArrayList<Grammar>();
            SequenceIterator i = args[0].iterate();
            while (i.hasNext()) {
                String url = i.nextItem().getStringValue();
                if (url.startsWith("/")) {
                    url = "xmldb:exist://" + url;
                }
                LOG.debug("Parsing " + url);
                try {
                    if (url.endsWith(".xsd")) {
                        InputStream is = new URL(url).openStream();
                        XMLInputSource xis = new XMLInputSource(null, url, url, is, null);
                        Grammar schema = parser.preparseGrammar(TYPE_XSD, xis);
                        is.close();
                        allGrammars.add(schema);
                        continue;
                    }
                    throw new XPathException((Expression)this, "Only XMLSchemas can be preparsed.");
                }
                catch (Exception ex) {
                    LOG.debug((Object)ex);
                    throw new XPathException((Expression)this, (Throwable)ex);
                }
            }
            LOG.debug("Successfully parsed " + allGrammars.size() + " grammars.");
            Grammar[] grammars = new Grammar[allGrammars.size()];
            grammars = allGrammars.toArray(grammars);
            grammarpool.cacheGrammars(TYPE_XSD, grammars);
            ValueSequence result = new ValueSequence();
            for (Grammar one : grammars) {
                result.add(new StringValue(one.getGrammarDescription().getNamespace()));
            }
            return result;
        }
        LOG.error("function not found error");
        throw new XPathException((Expression)this, "function not found");
    }

    private int countTotalNumberOfGrammar(GrammarPool grammarpool) {
        return grammarpool.retrieveInitialGrammarSet(TYPE_XSD).length + grammarpool.retrieveInitialGrammarSet(TYPE_DTD).length;
    }

    private void clearGrammarPool(GrammarPool grammarpool) {
        grammarpool.clear();
    }

    private NodeImpl writeReport(GrammarPool grammarpool, MemTreeBuilder builder) {
        Grammar[] dtds;
        Grammar[] xsds;
        int nodeNr = builder.startElement("", "report", "report", null);
        for (Grammar xsd : xsds = grammarpool.retrieveInitialGrammarSet(TYPE_XSD)) {
            this.writeGrammar(xsd, builder);
        }
        for (Grammar dtd : dtds = grammarpool.retrieveInitialGrammarSet(TYPE_DTD)) {
            this.writeGrammar(dtd, builder);
        }
        builder.endElement();
        return builder.getDocument().getNode(nodeNr);
    }

    private void writeGrammar(Grammar grammar, MemTreeBuilder builder) {
        String expandedSystemId;
        String literalSystemId;
        String baseSystemId;
        String publicId;
        XMLGrammarDescription xgd = grammar.getGrammarDescription();
        AttributesImpl attribs = new AttributesImpl();
        attribs.addAttribute("", "type", "type", "CDATA", xgd.getGrammarType());
        builder.startElement("", "grammar", "grammar", attribs);
        String namespace = xgd.getNamespace();
        if (namespace != null) {
            builder.startElement("", "Namespace", "Namespace", null);
            builder.characters(namespace);
            builder.endElement();
        }
        if ((publicId = xgd.getPublicId()) != null) {
            builder.startElement("", "PublicId", "PublicId", null);
            builder.characters(publicId);
            builder.endElement();
        }
        if ((baseSystemId = xgd.getBaseSystemId()) != null) {
            builder.startElement("", "BaseSystemId", "BaseSystemId", null);
            builder.characters(baseSystemId);
            builder.endElement();
        }
        if ((literalSystemId = xgd.getLiteralSystemId()) != null) {
            builder.startElement("", "LiteralSystemId", "LiteralSystemId", null);
            builder.characters(literalSystemId);
            builder.endElement();
        }
        if ((expandedSystemId = xgd.getExpandedSystemId()) != null) {
            builder.startElement("", "ExpandedSystemId", "ExpandedSystemId", null);
            builder.characters(expandedSystemId);
            builder.endElement();
        }
        builder.endElement();
        attribs.clear();
    }
}

