/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.validation;

import java.net.MalformedURLException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.memtree.NodeImpl;
import org.exist.validation.ValidationReport;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.validation.Shared;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;

public class Jaxv
extends BasicFunction {
    private static final String extendedFunctionTxt = "Validate document specified by $instance using the schemas in $grammars. Based on functionality provided by 'javax.xml.validation.Validator'. Only '.xsd' grammars are supported.";
    private static final String instanceText = "The document referenced as xs:anyURI, a node (element or returned by fn:doc()) or as a Java file object.";
    private static final String grammarText = "One of more XML Schema documents (.xsd), referenced as xs:anyURI, a node (element or returned by fn:doc()) or as Java file objects.";
    private static final String languageText = "The namespace URI to designate a schema language. Depending on the jaxv.SchemaFactory implementation the following values are valid:(XSD 1.0) http://www.w3.org/2001/XMLSchema http://www.w3.org/XML/XMLSchema/v1.0, (XSD 1.1) http://www.w3.org/XML/XMLSchema/v1.1, (RELAX NG 1.0) http://relaxng.org/ns/structure/1.0";
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("jaxv", "http://exist-db.org/xquery/validation", "validation"), "Validate document specified by $instance using the schemas in $grammars. Based on functionality provided by 'javax.xml.validation.Validator'. Only '.xsd' grammars are supported.", new SequenceType[]{new FunctionParameterSequenceType("instance", 11, 2, "The document referenced as xs:anyURI, a node (element or returned by fn:doc()) or as a Java file object."), new FunctionParameterSequenceType("grammars", 11, 6, "The namespace URI to designate a schema language. Depending on the jaxv.SchemaFactory implementation the following values are valid:(XSD 1.0) http://www.w3.org/2001/XMLSchema http://www.w3.org/XML/XMLSchema/v1.0, (XSD 1.1) http://www.w3.org/XML/XMLSchema/v1.1, (RELAX NG 1.0) http://relaxng.org/ns/structure/1.0")}, new FunctionReturnSequenceType(23, 2, "true() if the document is valid and no single problem occured, false() for all other conditions. For detailed validation information use the corresponding -report() function.")), new FunctionSignature(new QName("jaxv", "http://exist-db.org/xquery/validation", "validation"), "Validate document specified by $instance using the schemas in $grammars. Based on functionality provided by 'javax.xml.validation.Validator'. Only '.xsd' grammars are supported.", new SequenceType[]{new FunctionParameterSequenceType("instance", 11, 2, "The document referenced as xs:anyURI, a node (element or returned by fn:doc()) or as a Java file object."), new FunctionParameterSequenceType("grammars", 11, 6, "One of more XML Schema documents (.xsd), referenced as xs:anyURI, a node (element or returned by fn:doc()) or as Java file objects."), new FunctionParameterSequenceType("language", 22, 2, "The namespace URI to designate a schema language. Depending on the jaxv.SchemaFactory implementation the following values are valid:(XSD 1.0) http://www.w3.org/2001/XMLSchema http://www.w3.org/XML/XMLSchema/v1.0, (XSD 1.1) http://www.w3.org/XML/XMLSchema/v1.1, (RELAX NG 1.0) http://relaxng.org/ns/structure/1.0")}, new FunctionReturnSequenceType(23, 2, "true() if the document is valid and no single problem occured, false() for all other conditions. For detailed validation information use the corresponding -report() function.")), new FunctionSignature(new QName("jaxv-report", "http://exist-db.org/xquery/validation", "validation"), "Validate document specified by $instance using the schemas in $grammars. Based on functionality provided by 'javax.xml.validation.Validator'. Only '.xsd' grammars are supported. An XML report is returned.", new SequenceType[]{new FunctionParameterSequenceType("instance", 11, 2, "The document referenced as xs:anyURI, a node (element or returned by fn:doc()) or as a Java file object."), new FunctionParameterSequenceType("grammars", 11, 6, "One of more XML Schema documents (.xsd), referenced as xs:anyURI, a node (element or returned by fn:doc()) or as Java file objects.")}, new FunctionReturnSequenceType(-1, 2, "a validation report.")), new FunctionSignature(new QName("jaxv-report", "http://exist-db.org/xquery/validation", "validation"), "Validate document specified by $instance using the schemas in $grammars. Based on functionality provided by 'javax.xml.validation.Validator'. Only '.xsd' grammars are supported. An XML report is returned.", new SequenceType[]{new FunctionParameterSequenceType("instance", 11, 2, "The document referenced as xs:anyURI, a node (element or returned by fn:doc()) or as a Java file object."), new FunctionParameterSequenceType("grammars", 11, 6, "One of more XML Schema documents (.xsd), referenced as xs:anyURI, a node (element or returned by fn:doc()) or as Java file objects."), new FunctionParameterSequenceType("language", 22, 2, "The namespace URI to designate a schema language. Depending on the jaxv.SchemaFactory implementation the following values are valid:(XSD 1.0) http://www.w3.org/2001/XMLSchema http://www.w3.org/XML/XMLSchema/v1.0, (XSD 1.1) http://www.w3.org/XML/XMLSchema/v1.1, (RELAX NG 1.0) http://relaxng.org/ns/structure/1.0")}, new FunctionReturnSequenceType(-1, 2, "a validation report."))};

    public Jaxv(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args.length != 2 && args.length != 3) {
            return Sequence.EMPTY_SEQUENCE;
        }
        ValidationReport report = new ValidationReport();
        StreamSource instance = null;
        Source[] grammars = null;
        String schemaLang = "http://www.w3.org/2001/XMLSchema";
        try {
            report.start();
            instance = Shared.getStreamSource(args[0].itemAt(0), this.context);
            for (StreamSource grammar : grammars = Shared.getStreamSource(args[1], this.context)) {
                String grammarUrl = grammar.getSystemId();
                if (grammarUrl == null || grammarUrl.endsWith(".xsd") || grammarUrl.endsWith(".rng")) continue;
                throw new XPathException("Only XML schemas (.xsd) and RELAXNG grammars (.rng) are supported, depending on the used XML parser.");
            }
            if (args.length == 3) {
                schemaLang = args[2].getStringValue();
            }
            SchemaFactory factory = null;
            try {
                factory = SchemaFactory.newInstance(schemaLang);
            }
            catch (IllegalArgumentException ex) {
                String msg = "Schema language '" + schemaLang + "' is not supported. " + ex.getMessage();
                LOG.error(msg);
                throw new XPathException(msg);
            }
            Schema schema = factory.newSchema(grammars);
            Validator validator = schema.newValidator();
            validator.setErrorHandler(report);
            validator.validate(instance);
            report.stop();
        }
        catch (MalformedURLException ex) {
            LOG.error(ex.getMessage());
            report.setException(ex);
            report.stop();
            Shared.closeStreamSource(instance);
            Shared.closeStreamSources(grammars);
        }
        catch (Throwable ex2) {
            LOG.error((Object)ex2);
            report.setException(ex2);
            report.stop();
            {
                catch (Throwable throwable) {
                    report.stop();
                    Shared.closeStreamSource(instance);
                    Shared.closeStreamSources(grammars);
                    throw throwable;
                }
            }
            Shared.closeStreamSource(instance);
            Shared.closeStreamSources(grammars);
        }
        Shared.closeStreamSource(instance);
        Shared.closeStreamSources((StreamSource[])grammars);
        if (this.isCalledAs("jaxv")) {
            ValueSequence result = new ValueSequence();
            result.add(new BooleanValue(report.isValid()));
            return result;
        }
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        NodeImpl result = Shared.writeReport(report, builder);
        return result;
    }
}

