/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.validation;

import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import java.net.MalformedURLException;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.memtree.NodeImpl;
import org.exist.storage.BrokerPool;
import org.exist.validation.ValidationReport;
import org.exist.validation.resolver.unstable.ExistResolver;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.validation.Shared;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;
import org.xml.sax.InputSource;

public class Jing
extends BasicFunction {
    private static final String extendedFunctionTxt = "Validate document using 'Jing'. Supported grammar documents extensions are \".xsd\" \".rng\" \".rnc\" \".sch\" and \".nvdl\". Based on functionality provided by 'com.thaiopensource.validate.ValidationDriver'.";
    private static final String instanceText = "The document referenced as xs:anyURI, a node (element or returned by fn:doc()) or as a Java file object.";
    private static final String grammarText = "The grammar document as node (element of returned by fn:doc()), xs:anyURI, returned by util:binary-doc() or as a Java file object.";
    private final BrokerPool brokerPool;
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("jing", "http://exist-db.org/xquery/validation", "validation"), "Validate document using 'Jing'. Supported grammar documents extensions are \".xsd\" \".rng\" \".rnc\" \".sch\" and \".nvdl\". Based on functionality provided by 'com.thaiopensource.validate.ValidationDriver'.", new SequenceType[]{new FunctionParameterSequenceType("instance", 11, 2, "The document referenced as xs:anyURI, a node (element or returned by fn:doc()) or as a Java file object."), new FunctionParameterSequenceType("grammar", 11, 2, "The grammar document as node (element of returned by fn:doc()), xs:anyURI, returned by util:binary-doc() or as a Java file object.")}, new FunctionReturnSequenceType(23, 2, "true() if the document is valid and no single problem occured, false() for all other conditions. For detailed validation information use the corresponding -report() function.")), new FunctionSignature(new QName("jing-report", "http://exist-db.org/xquery/validation", "validation"), "Validate document using 'Jing'. Supported grammar documents extensions are \".xsd\" \".rng\" \".rnc\" \".sch\" and \".nvdl\". Based on functionality provided by 'com.thaiopensource.validate.ValidationDriver'. An XML report is returned.", new SequenceType[]{new FunctionParameterSequenceType("instance", 11, 2, "The document referenced as xs:anyURI, a node (element or returned by fn:doc()) or as a Java file object."), new FunctionParameterSequenceType("grammar", 11, 2, "The grammar document as node (element of returned by fn:doc()), xs:anyURI, returned by util:binary-doc() or as a Java file object.")}, new FunctionReturnSequenceType(-1, 2, "a validation report."))};

    public Jing(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
        this.brokerPool = context.getBroker().getBrokerPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args.length != 2) {
            return Sequence.EMPTY_SEQUENCE;
        }
        ValidationReport report = new ValidationReport();
        InputSource instance = null;
        InputSource grammar = null;
        try {
            report.start();
            instance = Shared.getInputSource(args[0].itemAt(0), this.context);
            grammar = Shared.getInputSource(args[1].itemAt(0), this.context);
            String grammarUrl = grammar.getSystemId();
            SchemaReader schemaReader = grammarUrl != null && grammarUrl.endsWith(".rnc") ? CompactSchemaReader.getInstance() : null;
            PropertyMapBuilder properties = new PropertyMapBuilder();
            ValidateProperty.ERROR_HANDLER.put(properties, (Object)report);
            ExistResolver resolver = new ExistResolver(this.brokerPool);
            ValidateProperty.URI_RESOLVER.put(properties, (Object)resolver);
            ValidateProperty.ENTITY_RESOLVER.put(properties, (Object)resolver);
            ValidationDriver driver = new ValidationDriver(properties.toPropertyMap(), schemaReader);
            driver.loadSchema(grammar);
            driver.validate(instance);
        }
        catch (MalformedURLException ex) {
            LOG.error(ex.getMessage());
            report.setException(ex);
            Shared.closeInputSource(instance);
            Shared.closeInputSource(grammar);
            report.stop();
        }
        catch (Throwable ex2) {
            LOG.error((Object)ex2);
            report.setException(ex2);
            {
                catch (Throwable throwable) {
                    Shared.closeInputSource(instance);
                    Shared.closeInputSource(grammar);
                    report.stop();
                    throw throwable;
                }
            }
            Shared.closeInputSource(instance);
            Shared.closeInputSource(grammar);
            report.stop();
        }
        Shared.closeInputSource(instance);
        Shared.closeInputSource(grammar);
        report.stop();
        if (this.isCalledAs("jing")) {
            ValueSequence result = new ValueSequence();
            result.add(new BooleanValue(report.isValid()));
            return result;
        }
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        NodeImpl result = Shared.writeReport(report, builder);
        return result;
    }
}

