/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.validation;

import java.io.InputStream;
import java.net.MalformedURLException;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.memtree.NodeImpl;
import org.exist.storage.BrokerPool;
import org.exist.validation.ValidationReport;
import org.exist.validation.Validator;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.validation.Shared;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;

public class Validation
extends BasicFunction {
    private static final String CONVENIENCE = "This is the original and oldest validation function of eXist-db. It basically wraps the jing library for .rnc/.rnc/.sch/.nvdl grammar files and uses the jaxp functionality otherwise. ";
    private static final String DEPRECATED_1 = "This is the original and oldest validation function of eXist-db. It basically wraps the jing library for .rnc/.rnc/.sch/.nvdl grammar files and uses the jaxp functionality otherwise. It is recommended to use the validation:jaxp-parse(), validation:jaxv() or validation:jing() functions instead.";
    private static final String DEPRECATED_2 = "This is the original and oldest validation function of eXist-db. It basically wraps the jing library for .rnc/.rnc/.sch/.nvdl grammar files and uses the jaxp functionality otherwise. It is recommended to use the validation:jaxp-parse-report(), validation:jaxv-report() or validation:jing-report() functions instead.";
    private static final String FUNCTION_TEXT = "Validate XML. The grammar files (DTD, XML Schema) are resolved using the global catalog file(s).";
    private static final String EXTENDED_FUNCTION_TEXT = "Validate XML by using a specific grammar.";
    private static final String GRAMMAR_DESCRIPTION = "The reference to an OASIS catalog file (.xml), a collection (path ends with '/') or a grammar document. Supported grammar documents extensions are \".dtd\" \".xsd\" \".rng\" \".rnc\" \".sch\" and \".nvdl\". The parameter can be passed as an xs:anyURI or a document node.";
    private static final String INSTANCE_DESCRIPTION = "The document referenced as xs:anyURI or a node (element or returned by fn:doc())";
    private static final String XML_REPORT_RETURN = " An XML report is returned.";
    private final Validator validator;
    private final BrokerPool brokerPool;
    public static final FunctionSignature[] deprecated = new FunctionSignature[]{new FunctionSignature(new QName("validate", "http://exist-db.org/xquery/validation", "validation"), "Validate XML. The grammar files (DTD, XML Schema) are resolved using the global catalog file(s).", new SequenceType[]{new FunctionParameterSequenceType("instance", 11, 2, "The document referenced as xs:anyURI or a node (element or returned by fn:doc())")}, (SequenceType)new FunctionReturnSequenceType(23, 2, "true() if the document is valid and no single problem occured, false() for all other conditions. For detailed validation information use the corresponding -report() function."), "This is the original and oldest validation function of eXist-db. It basically wraps the jing library for .rnc/.rnc/.sch/.nvdl grammar files and uses the jaxp functionality otherwise. It is recommended to use the validation:jaxp-parse(), validation:jaxv() or validation:jing() functions instead."), new FunctionSignature(new QName("validate", "http://exist-db.org/xquery/validation", "validation"), "Validate XML by using a specific grammar.", new SequenceType[]{new FunctionParameterSequenceType("instance", 11, 2, "The document referenced as xs:anyURI or a node (element or returned by fn:doc())"), new FunctionParameterSequenceType("grammar", 25, 2, "The reference to an OASIS catalog file (.xml), a collection (path ends with '/') or a grammar document. Supported grammar documents extensions are \".dtd\" \".xsd\" \".rng\" \".rnc\" \".sch\" and \".nvdl\". The parameter can be passed as an xs:anyURI or a document node.")}, (SequenceType)new FunctionReturnSequenceType(-1, 2, "true() if the document is valid and no single problem occured, false() for all other conditions. For detailed validation information use the corresponding -report() function."), "This is the original and oldest validation function of eXist-db. It basically wraps the jing library for .rnc/.rnc/.sch/.nvdl grammar files and uses the jaxp functionality otherwise. It is recommended to use the validation:jaxp-parse(), validation:jaxv() or validation:jing() functions instead."), new FunctionSignature(new QName("validate-report", "http://exist-db.org/xquery/validation", "validation"), "Validate XML. The grammar files (DTD, XML Schema) are resolved using the global catalog file(s). An XML report is returned.", new SequenceType[]{new FunctionParameterSequenceType("instance", 11, 2, "The document referenced as xs:anyURI or a node (element or returned by fn:doc())")}, (SequenceType)new FunctionReturnSequenceType(-1, 2, "a validation report."), "This is the original and oldest validation function of eXist-db. It basically wraps the jing library for .rnc/.rnc/.sch/.nvdl grammar files and uses the jaxp functionality otherwise. It is recommended to use the validation:jaxp-parse-report(), validation:jaxv-report() or validation:jing-report() functions instead."), new FunctionSignature(new QName("validate-report", "http://exist-db.org/xquery/validation", "validation"), "Validate XML by using a specific grammar. An XML report is returned.", new SequenceType[]{new FunctionParameterSequenceType("instance", 11, 2, "The document referenced as xs:anyURI or a node (element or returned by fn:doc())"), new FunctionParameterSequenceType("grammar", 11, 2, "The reference to an OASIS catalog file (.xml), a collection (path ends with '/') or a grammar document. Supported grammar documents extensions are \".dtd\" \".xsd\" \".rng\" \".rnc\" \".sch\" and \".nvdl\". The parameter can be passed as an xs:anyURI or a document node.")}, (SequenceType)new FunctionReturnSequenceType(-1, 2, "a validation report."), "This is the original and oldest validation function of eXist-db. It basically wraps the jing library for .rnc/.rnc/.sch/.nvdl grammar files and uses the jaxp functionality otherwise. It is recommended to use the validation:jaxp-parse-report(), validation:jaxv-report() or validation:jing-report() functions instead.")};

    public Validation(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
        this.brokerPool = context.getBroker().getBrokerPool();
        this.validator = new Validator(this.brokerPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args.length != 1 && args.length != 2) {
            return Sequence.EMPTY_SEQUENCE;
        }
        InputStream is = null;
        ValidationReport report = new ValidationReport();
        try {
            is = Shared.getInputStream(args[0].itemAt(0), this.context);
            if (args.length == 1) {
                report = this.validator.validate(is);
            } else {
                String url = Shared.getUrl(args[1].itemAt(0));
                report = this.validator.validate(is, url);
            }
        }
        catch (MalformedURLException ex) {
            LOG.error(ex.getMessage());
            report.setException(ex);
        }
        catch (Throwable ex) {
            LOG.error((Object)ex);
            report.setException(ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ex) {
                    LOG.debug("Attemted to close stream. ignore.", (Throwable)ex);
                }
            }
        }
        if (this.isCalledAs("validate") || this.isCalledAs("jing")) {
            ValueSequence result = new ValueSequence();
            result.add(new BooleanValue(report.isValid()));
            return result;
        }
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        NodeImpl result = Shared.writeReport(report, builder);
        return result;
    }
}

