/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.dom.QName;
import org.exist.http.servlets.RequestWrapper;
import org.exist.http.servlets.SessionWrapper;
import org.exist.security.AuthenticationException;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.UserSwitchingBasicFunction;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.request.RequestModule;
import org.exist.xquery.functions.session.SessionModule;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class XMLDBAuthenticate
extends UserSwitchingBasicFunction {
    private static final Logger logger = LogManager.getLogger(XMLDBAuthenticate.class);
    public static final FunctionSignature authenticateSignature = new FunctionSignature(new QName("authenticate", "http://exist-db.org/xquery/xmldb", "xmldb"), "Check if the user, $user-id, can authenticate against the database collection $collection-uri. The function simply tries to read the collection $collection-uri, using the credentials $user-id and $password. Collection URIs can be specified either as a simple collection path or an XMLDB URI. It returns true if the authentication succeeds, false otherwise.", new SequenceType[]{new FunctionParameterSequenceType("collection-uri", 22, 2, "The collection URI"), new FunctionParameterSequenceType("user-id", 22, 3, "The user-id"), new FunctionParameterSequenceType("password", 22, 3, "The password")}, new FunctionReturnSequenceType(23, 2, "true() on successful authentication, false() otherwise"));
    public static final FunctionSignature[] loginSignatures = new FunctionSignature[]{new FunctionSignature(new QName("login", "http://exist-db.org/xquery/xmldb", "xmldb"), "Login the user, $user-id, and set it as the owner of the currently executing XQuery. Collection URIs can be specified either as a simple collection path or an XMLDB URI. It returns true if the authentication succeeds, false otherwise. If called from a HTTP context the login is cached for the lifetime of the HTTP session and may be used for any XQuery run in that session. If an HTTP session does not already exist, none will be created.", new SequenceType[]{new FunctionParameterSequenceType("collection-uri", 22, 2, "The collection URI"), new FunctionParameterSequenceType("user-id", 22, 3, "The user-id"), new FunctionParameterSequenceType("password", 22, 3, "The password")}, new FunctionReturnSequenceType(23, 2, "true() on successful authentication and owner elevation, false() otherwise")), new FunctionSignature(new QName("login", "http://exist-db.org/xquery/xmldb", "xmldb"), "Login the user, $user-id, and set it as the owner of the currently executing XQuery. Collection URIs can be specified either as a simple collection path or an XMLDB URI. It returns true() if the authentication succeeds, false() otherwise. If called from a HTTP context the login is cached for the lifetime of the HTTP session and may be used for any XQueryrun in that session. $create-session specifies whether to create an HTTP session on successful authentication or not. If $create-session is false() or the empty sequence no session will be created if one does not already exist.", new SequenceType[]{new FunctionParameterSequenceType("collection-uri", 22, 2, "The collection URI"), new FunctionParameterSequenceType("user-id", 22, 3, "The user-id"), new FunctionParameterSequenceType("password", 22, 3, "The password"), new FunctionParameterSequenceType("create-session", 23, 3, "whether to create the session or not on successful authentication, default false()")}, new FunctionReturnSequenceType(23, 2, "true() on successful authentication and owner elevation, false() otherwise"))};

    public XMLDBAuthenticate(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[1].isEmpty()) {
            return BooleanValue.FALSE;
        }
        String uri = args[0].getStringValue();
        String userName = args[1].getStringValue();
        if (userName == null) {
            logger.error("Unable to authenticate username == NULL");
            return BooleanValue.FALSE;
        }
        String password = args[2].getStringValue();
        boolean createSession = args.length > 3 && args[3].effectiveBooleanValue();
        XmldbURI targetColl = !uri.startsWith("xmldb:") ? XmldbURI.EMBEDDED_SERVER_URI.resolveCollectionPath(XmldbURI.create(uri)) : XmldbURI.create(uri);
        try {
            Subject user;
            try {
                SecurityManager sm = BrokerPool.getInstance().getSecurityManager();
                user = sm.authenticate(userName, password);
            }
            catch (EXistException | AuthenticationException e) {
                logger.error("Unable to authenticate user: " + userName + " " + this.getLocation(), (Throwable)e);
                return BooleanValue.FALSE;
            }
            Collection root = DatabaseManager.getCollection((String)targetColl.toString(), (String)userName, (String)password);
            if (root == null) {
                logger.error("Unable to authenticate user: target collection " + targetColl + " does not exist " + this.getLocation());
                return BooleanValue.FALSE;
            }
            if (this.isCalledAs("login")) {
                this.switchUser(user);
                this.cacheUserInHttpSession(user, createSession);
            }
            return BooleanValue.TRUE;
        }
        catch (XMLDBException e) {
            logger.error(this.getLocation() + " : " + e.getMessage(), (Throwable)e);
            return BooleanValue.FALSE;
        }
    }

    private String getLocation() {
        return "@ " + this.getContext().getSource().path() + " [" + this.getLine() + ":" + this.getColumn() + "]";
    }

    private void cacheUserInHttpSession(Subject user, boolean createSession) throws XPathException {
        JavaObjectValue session;
        Variable var = this.getSessionVar(createSession);
        if (var != null && var.getValue() != null && var.getValue().getItemType() == 100 && (session = (JavaObjectValue)var.getValue().itemAt(0)).getObject() instanceof SessionWrapper) {
            ((SessionWrapper)session.getObject()).setAttribute("_eXist_xmldb_user", (Object)user);
        }
    }

    private Variable getSessionVar(boolean createSession) throws XPathException {
        SessionModule sessionModule = (SessionModule)this.context.getModule("http://exist-db.org/xquery/session");
        Variable var = sessionModule.resolveVariable(SessionModule.SESSION_VAR);
        if (createSession && (var == null || var.getValue() == null)) {
            RequestModule reqModule = (RequestModule)this.context.getModule("http://exist-db.org/xquery/request");
            Variable reqVar = reqModule.resolveVariable(RequestModule.REQUEST_VAR);
            if (reqVar == null || reqVar.getValue() == null) {
                logger.error("No request object found in the current XQuery context.");
                throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "No request object found in the current XQuery context.");
            }
            if (reqVar.getValue().getItemType() != 100) {
                logger.error("Variable $request is not bound to an Java object.");
                throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $request is not bound to an Java object.");
            }
            JavaObjectValue reqValue = (JavaObjectValue)reqVar.getValue().itemAt(0);
            if (reqValue.getObject() instanceof RequestWrapper) {
                SessionWrapper session = ((RequestWrapper)reqValue.getObject()).getSession(true);
                var = sessionModule.declareVariable(SessionModule.SESSION_VAR, (Object)session);
            }
        }
        return var;
    }
}

