/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import java.net.URISyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xmldb.EXistCollectionManagementService;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class XMLDBCopy
extends XMLDBAbstractCollectionManipulator {
    private static final Logger logger = LogManager.getLogger(XMLDBCopy.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("copy", "http://exist-db.org/xquery/xmldb", "xmldb"), "Copy the collection $source-collection-uri to the collection $target-collection-uri. Collection URIs can be specified either as a simple collection path or an XMLDB URI.", new SequenceType[]{new FunctionParameterSequenceType("source-collection-uri", 22, 2, "The source collection URI"), new FunctionParameterSequenceType("target-collection-uri", 22, 2, "The target collection URI")}, new SequenceType(11, 1)), new FunctionSignature(new QName("copy", "http://exist-db.org/xquery/xmldb", "xmldb"), "Copy the resource $resource in $source-collection-uri to collection $target-collection-uri. Collection URIs can be specified either as a simple collection path or an XMLDB URI.", new SequenceType[]{new FunctionParameterSequenceType("source-collection-uri", 22, 2, "The source collection URI"), new FunctionParameterSequenceType("target-collection-uri", 22, 2, "the target collection URI"), new FunctionParameterSequenceType("resource", 22, 2, "the resource to copy")}, new SequenceType(11, 1))};

    public XMLDBCopy(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        XmldbURI destination = new AnyURIValue(args[1].itemAt(0).getStringValue()).toXmldbURI();
        if (this.getSignature().getArgumentCount() == 3) {
            XmldbURI doc = new AnyURIValue(args[2].itemAt(0).getStringValue()).toXmldbURI();
            try {
                Resource resource = collection.getResource(doc.toString());
                if (resource == null) {
                    logger.error("Resource " + doc + " not found");
                    throw new XPathException((Expression)this, "Resource " + doc + " not found");
                }
                EXistCollectionManagementService service = (EXistCollectionManagementService)collection.getService("CollectionManagementService", "1.0");
                service.copyResource(doc, destination, null);
            }
            catch (XMLDBException e) {
                logger.error("XMLDB exception caught: ", (Throwable)e);
                throw new XPathException((Expression)this, "XMLDB exception caught: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            EXistCollectionManagementService service = (EXistCollectionManagementService)collection.getService("CollectionManagementService", "1.0");
            service.copy(XmldbURI.xmldbUriFor(collection.getName()), destination, null);
        }
        catch (XMLDBException e) {
            logger.error("Cannot copy collection: ", (Throwable)e);
            throw new XPathException((Expression)this, "Cannot copy collection: " + e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            logger.error("URI exception: ", (Throwable)e);
            throw new XPathException((Expression)this, "URI exception: " + e.getMessage(), (Throwable)e);
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

