/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.dom.QName;
import org.exist.security.Account;
import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.security.internal.aider.GroupAider;
import org.exist.storage.DBBroker;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.securitymanager.GroupManagementFunction;
import org.exist.xquery.functions.xmldb.XMLDBCreateUser;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;

@Deprecated
public class XMLDBCreateGroup
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(XMLDBCreateUser.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("create-group", "http://exist-db.org/xquery/xmldb", "xmldb"), "Create a new user group. $group is the group name. The current user will be the groups manager.", new SequenceType[]{new FunctionParameterSequenceType("group", 22, 2, "The group name")}, (SequenceType)new FunctionReturnSequenceType(23, 2, "true() or false() indicating the outcome of the operation"), GroupManagementFunction.FNS_CREATE_GROUP), new FunctionSignature(new QName("create-group", "http://exist-db.org/xquery/xmldb", "xmldb"), "Create a new user group, with an initial member. $group is the group name, $group-manager-username are the groups managers in addition to the current user.", new SequenceType[]{new FunctionParameterSequenceType("group", 22, 2, "The group name"), new FunctionParameterSequenceType("group-manager-username", 22, 6, "The name of the user(s) who will be the groups manager")}, (SequenceType)new FunctionReturnSequenceType(23, 2, "true() or false() indicating the outcome of the operation"), GroupManagementFunction.FNS_CREATE_GROUP_WITH_MANAGERS_WITH_METADATA)};

    public XMLDBCreateGroup(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String groupName = args[0].getStringValue();
        if ("guest".equals(this.context.getSubject().getName()) || "dba".equals(groupName)) {
            XPathException xPathException = new XPathException((Expression)this, "Permission denied, calling account '" + this.context.getSubject().getName() + "' must be an authenticated account to call this function.");
            logger.error("Invalid user", (Throwable)xPathException);
            throw xPathException;
        }
        logger.info("Attempting to create group " + groupName);
        Group group = new GroupAider(groupName);
        DBBroker broker = this.context.getBroker();
        Subject currentUser = broker.getCurrentSubject();
        try {
            SecurityManager sm = broker.getBrokerPool().getSecurityManager();
            group.addManager(currentUser);
            if (args.length == 2) {
                SequenceIterator i = args[1].iterate();
                while (i.hasNext()) {
                    String groupManager = i.nextItem().getStringValue();
                    Account groupManagerAccount = sm.getAccount(groupManager);
                    if (groupManagerAccount == null) {
                        logger.error("Could not find the user: " + groupManager);
                        return BooleanValue.FALSE;
                    }
                    group.addManager(groupManagerAccount);
                }
            }
            group = sm.addGroup(this.context.getBroker(), group);
            try {
                this.context.getBroker().pushSubject(sm.getSystemSubject());
                for (Account manager : group.getManagers()) {
                    manager.addGroup(group);
                    sm.updateAccount(manager);
                }
            }
            finally {
                this.context.getBroker().popSubject();
            }
            return BooleanValue.TRUE;
        }
        catch (PermissionDeniedException pde) {
            throw new XPathException((Expression)this, "Permission denied, calling account '" + this.context.getSubject().getName() + "' do not authorize to call this function.");
        }
        catch (EXistException exe) {
            logger.error("Failed to create group: " + group, (Throwable)exe);
            return BooleanValue.FALSE;
        }
    }
}

