/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.security.internal.aider.UserAider;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.securitymanager.AccountManagementFunction;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.XMLDBException;

@Deprecated
public class XMLDBCreateUser
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(XMLDBCreateUser.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("create-user", "http://exist-db.org/xquery/xmldb", "xmldb"), "Create a new user, $user-id, in the database. The XQuery owner must have appropriate privileges to do this, e.g. having DBA role. $user-id is the username, $password is the password, $groups is the sequence of group memberships. The first group in the sequence is the primary group.$home-collection-uri is the home collection URI.Collection URIs can be specified either as a simple collection path or an XMLDB URI.", new SequenceType[]{new FunctionParameterSequenceType("user-id", 22, 2, "The user-id"), new FunctionParameterSequenceType("password", 22, 2, "The password"), new FunctionParameterSequenceType("groups", 22, 6, "The group memberships"), new FunctionParameterSequenceType("home-collection-uri", 22, 3, "The home collection URI")}, new SequenceType(11, 1), "$home-collection-uri has no effect since 2.0. You should use the sm:create-account function from the SecurityManager module instead."), new FunctionSignature(new QName("create-user", "http://exist-db.org/xquery/xmldb", "xmldb"), "Create a new user, $user-id, in the database. The XQuery owner must have appropriate privileges to do this, e.g. having DBA role. $user-id is the username, $password is the password, $groups is the sequence of group memberships. The first group in the sequence is the primary group.Collection URIs can be specified either as a simple collection path or an XMLDB URI.", new SequenceType[]{new FunctionParameterSequenceType("user-id", 22, 2, "The user-id"), new FunctionParameterSequenceType("password", 22, 2, "The password"), new FunctionParameterSequenceType("groups", 22, 6, "The group memberships")}, new SequenceType(11, 1), AccountManagementFunction.FNS_CREATE_ACCOUNT_WITH_PERSONAL_GROUP_WITH_METADATA)};

    public XMLDBCreateUser(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (!this.context.getSubject().hasDbaRole()) {
            XPathException xPathException = new XPathException((Expression)this, "Permission denied, calling user '" + this.context.getSubject().getName() + "' must be a DBA to call this function.");
            logger.error("Invalid user", (Throwable)xPathException);
            throw xPathException;
        }
        String user = args[0].getStringValue();
        String pass = args[1].getStringValue();
        logger.info("Attempting to create user " + user);
        UserAider userObj = new UserAider(user);
        userObj.setPassword(pass);
        Sequence groups = args[2];
        int len = groups.getItemCount();
        for (int x = 0; x < len; ++x) {
            userObj.addGroup(groups.itemAt(x).getStringValue());
        }
        LocalCollection collection = null;
        try {
            collection = new LocalCollection(this.context.getSubject(), this.context.getBroker().getBrokerPool(), XmldbURI.ROOT_COLLECTION_URI);
            UserManagementService ums = (UserManagementService)collection.getService("UserManagementService", "1.0");
            ums.addAccount(userObj);
        }
        catch (XMLDBException xe) {
            logger.error("Failed to create user: " + user);
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to create user: " + user, (Throwable)xe);
            }
            throw new XPathException((Expression)this, "Failed to create new user '" + user + "' by " + this.context.getSubject().getName(), (Throwable)xe);
        }
        finally {
            if (null != collection) {
                try {
                    collection.close();
                }
                catch (XMLDBException xMLDBException) {}
            }
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

