/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xmldb.EXistCollection;
import org.exist.xmldb.EXistResource;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class XMLDBCreated
extends XMLDBAbstractCollectionManipulator {
    private static final Logger logger = LogManager.getLogger(XMLDBCreated.class);
    public static final FunctionSignature[] createdSignatures = new FunctionSignature[]{new FunctionSignature(new QName("created", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the creation date of the resource $resource in $collection-uri. Collection URIs can be specified either as a simple collection path or an XMLDB URI.", new SequenceType[]{new FunctionParameterSequenceType("collection-uri", 22, 2, "The collection URI"), new FunctionParameterSequenceType("resource", 22, 2, "The resource")}, new FunctionReturnSequenceType(50, 2, "the creation date")), new FunctionSignature(new QName("created", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the creation date of the collection $collection-uri. Collection URIs can be specified either as a simple collection path or an XMLDB URI.", new SequenceType[]{new FunctionParameterSequenceType("collection-uri", 22, 2, "The collection URI")}, new FunctionReturnSequenceType(50, 2, "the creation date"))};
    public static final FunctionSignature lastModifiedSignature = new FunctionSignature(new QName("last-modified", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the last-modification date of resource $resource in collection $collection-uri. Collection URIs can be specified either as a simple collection path or an XMLDB URI.", new SequenceType[]{new FunctionParameterSequenceType("collection-uri", 11, 2, "The collection URI"), new FunctionParameterSequenceType("resource", 22, 2, "The resource")}, new FunctionReturnSequenceType(50, 3, "the last modification date"));

    public XMLDBCreated(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        try {
            Date date;
            if (this.getSignature().getArgumentCount() == 1) {
                date = ((EXistCollection)collection).getCreationTime();
            } else {
                Resource resource = collection.getResource(args[1].getStringValue());
                if (resource == null) {
                    return Sequence.EMPTY_SEQUENCE;
                }
                date = this.isCalledAs("last-modified") ? ((EXistResource)resource).getLastModificationTime() : ((EXistResource)resource).getCreationTime();
            }
            return new DateTimeValue(date);
        }
        catch (XMLDBException e) {
            logger.error("Failed to retrieve creation date or modification time of specified resource or creation date of collection");
            throw new XPathException((Expression)this, "Failed to retrieve creation date: " + e.getMessage(), (Throwable)e);
        }
    }
}

