/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.security.Account;
import org.exist.security.Subject;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.securitymanager.AccountManagementFunction;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.XMLDBException;

@Deprecated
public class XMLDBDeleteUser
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(XMLDBDeleteUser.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("delete-user", "http://exist-db.org/xquery/xmldb", "xmldb"), "Deletes an existing user, $user-id, in the database. This does not delete the user's home collection. The XQuery owner must have appropriate privileges to do this, e.g. having DBA role, and not being the owner of the currently running XQuery. You cannot delete the owner of the currently running XQuery.", new SequenceType[]{new FunctionParameterSequenceType("user-id", 22, 2, "The user-id to delete")}, new SequenceType(11, 1), AccountManagementFunction.FNS_REMOVE_ACCOUNT);

    public XMLDBDeleteUser(XQueryContext context) {
        super(context, signature);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String user = args[0].getStringValue();
        Subject contextUser = this.context.getSubject();
        if (contextUser.hasDbaRole()) {
            if (contextUser.getName().equals(user)) {
                XPathException xPathException = new XPathException((Expression)this, "Permission denied, calling user '" + this.context.getSubject().getName() + "' must not be deleting itself");
                logger.error("Invalid user", (Throwable)xPathException);
                throw xPathException;
            }
            LocalCollection collection = null;
            try {
                collection = new LocalCollection(contextUser, this.context.getBroker().getBrokerPool(), XmldbURI.ROOT_COLLECTION_URI);
                UserManagementService ums = (UserManagementService)collection.getService("UserManagementService", "1.0");
                Account userObj = ums.getAccount(user);
                if (null == userObj) return Sequence.EMPTY_SEQUENCE;
                ums.removeAccount(userObj);
                return Sequence.EMPTY_SEQUENCE;
            }
            catch (XMLDBException xe) {
                throw new XPathException((Expression)this, "Failed to remove user " + user, (Throwable)xe);
            }
            finally {
                if (null != collection) {
                    try {
                        collection.close();
                    }
                    catch (XMLDBException xMLDBException) {}
                }
            }
        }
        XPathException xPathException = new XPathException((Expression)this, "Permission denied, calling user '" + this.context.getSubject().getName() + "' must be a DBA to delete a user");
        logger.error("Invalid user", (Throwable)xPathException);
        throw xPathException;
    }
}

