/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import java.net.URISyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xmldb.EXistCollectionManagementService;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class XMLDBMove
extends XMLDBAbstractCollectionManipulator {
    protected static final Logger logger = LogManager.getLogger(XMLDBMove.class);
    protected static final FunctionParameterSequenceType ARG_SOURCE = new FunctionParameterSequenceType("source-collection-uri", 22, 2, "The source collection URI");
    protected static final FunctionParameterSequenceType ARG_TARGET = new FunctionParameterSequenceType("target-collection-uri", 22, 2, "The target collection URI");
    protected static final FunctionParameterSequenceType ARG_RESOURCE = new FunctionParameterSequenceType("resource", 22, 2, "The resource");
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("move", "http://exist-db.org/xquery/xmldb", "xmldb"), "Moves the collection $source-collection-uri into the collection $target-collection-uri. Collection URIs can be specified either as a simple collection path or an XMLDB URI.", new SequenceType[]{ARG_SOURCE, ARG_TARGET}, new SequenceType(11, 1)), new FunctionSignature(new QName("move", "http://exist-db.org/xquery/xmldb", "xmldb"), "Moves the resource $resource from the collection $source-collection-uri into collection $target-collection-uri. Collection URIs can be specified either as a simple collection path or an XMLDB URI.", new SequenceType[]{ARG_SOURCE, ARG_TARGET, ARG_RESOURCE}, new SequenceType(11, 1))};

    public XMLDBMove(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        XmldbURI destination = new AnyURIValue(args[1].itemAt(0).getStringValue()).toXmldbURI();
        if (this.getSignature().getArgumentCount() == 3) {
            XmldbURI doc = new AnyURIValue(args[2].itemAt(0).getStringValue()).toXmldbURI();
            try {
                Resource resource = collection.getResource(doc.toString());
                if (resource == null) {
                    logger.error("Resource " + doc + " not found");
                    throw new XPathException((Expression)this, "Resource " + doc + " not found");
                }
                EXistCollectionManagementService service = (EXistCollectionManagementService)collection.getService("CollectionManagementService", "1.0");
                service.moveResource(doc, destination, null);
            }
            catch (XMLDBException e) {
                logger.error(e.getMessage());
                throw new XPathException((Expression)this, "XMLDB exception caught: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            EXistCollectionManagementService service = (EXistCollectionManagementService)collection.getService("CollectionManagementService", "1.0");
            service.move(XmldbURI.xmldbUriFor(collection.getName()), destination, null);
        }
        catch (XMLDBException e) {
            logger.error(e.getMessage());
            throw new XPathException((Expression)this, "Cannot move collection: " + e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            logger.error(e.getMessage());
            throw new XPathException((Expression)this, "URI exception: " + e.getMessage(), (Throwable)e);
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

