/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.security.Permission;
import org.exist.security.PermissionFactory;
import org.exist.security.internal.aider.UnixStylePermissionAider;
import org.exist.util.SyntaxException;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.securitymanager.PermissionsFunction;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

@Deprecated
public class XMLDBPermissionsToString
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(XMLDBPermissionsToString.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("permissions-to-string", "http://exist-db.org/xquery/xmldb", "xmldb"), "Formats the resource or collection permissions, $permissions, passed as an integer value into a string. The returned string shows the permissions following the Unix conventions, i.e. all permissions set is returned as rwxrwxrwx, where the first three chars are for user permissions, followed by group and other users. 'r' denotes read, 'w' write and 'u' update permissions.", new SequenceType[]{new FunctionParameterSequenceType("permissions", 31, 2, "The permissions in xs:integer format")}, (SequenceType)new FunctionReturnSequenceType(22, 3, "the permissions as string 'rwu' for, user, group and other"), PermissionsFunction.FNS_OCTAL_TO_MODE), new FunctionSignature(new QName("string-to-permissions", "http://exist-db.org/xquery/xmldb", "xmldb"), "Converts the resource or collection permissions, $permissions-string, into an integer representation suitable for use with set-permissions functions. The permissions string should be in the format 'rwxrwxrwx' where r is read, w is write and u is update.", new SequenceType[]{new FunctionParameterSequenceType("permissions-string", 22, 2, "The permissions string")}, (SequenceType)new FunctionReturnSequenceType(31, 2, "The permissions integer"), PermissionsFunction.FNS_MODE_TO_OCTAL)};

    public XMLDBPermissionsToString(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.isCalledAs("permissions-to-string")) {
            int mode = ((IntegerValue)args[0].itemAt(0)).getInt();
            Permission perm = PermissionFactory.getPermission(this.context.getBroker().getBrokerPool().getSecurityManager(), mode);
            return new StringValue(perm.toString());
        }
        String permissionsString = args[0].itemAt(0).getStringValue();
        try {
            UnixStylePermissionAider perm = UnixStylePermissionAider.fromString(permissionsString);
            return new IntegerValue(perm.getMode());
        }
        catch (SyntaxException se) {
            throw new XPathException((Expression)this, (Throwable)se);
        }
    }
}

