/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;

public class XMLDBRemove
extends XMLDBAbstractCollectionManipulator {
    protected static final Logger logger = LogManager.getLogger(XMLDBRemove.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("remove", "http://exist-db.org/xquery/xmldb", "xmldb"), "Removes the collection $collection-uri and its contents from the database. Collection URIs can be specified either as a simple collection path or an XMLDB URI.", new SequenceType[]{new FunctionParameterSequenceType("collection-uri", 22, 2, "The collection URI")}, new SequenceType(11, 1)), new FunctionSignature(new QName("remove", "http://exist-db.org/xquery/xmldb", "xmldb"), "Removes the resource $resource from the collection $collection-uri. Collection URIs can be specified either as a simple collection path or an XMLDB URI.", new SequenceType[]{new FunctionParameterSequenceType("collection-uri", 22, 2, "The collection URI"), new FunctionParameterSequenceType("resource", 22, 2, "The resource")}, new SequenceType(11, 1))};

    public XMLDBRemove(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.getSignature().getArgumentCount() == 2) {
            String doc = new AnyURIValue(args[1].itemAt(0).getStringValue()).toXmldbURI().toString();
            try {
                Resource resource = collection.getResource(doc);
                if (resource == null) {
                    logger.error("Resource " + doc + " not found");
                    throw new XPathException((Expression)this, "Resource " + doc + " not found");
                }
                collection.removeResource(resource);
            }
            catch (XMLDBException e) {
                logger.error(e.getMessage());
                throw new XPathException((Expression)this, "XMLDB exception caught: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            CollectionManagementService service = (CollectionManagementService)collection.getService("CollectionManagementService", "1.0");
            service.removeCollection(collection.getName());
        }
        catch (XMLDBException e) {
            logger.error("Cannot remove collection: " + e.getMessage());
            throw new XPathException((Expression)this, "Cannot remove collection: " + e.getMessage(), (Throwable)e);
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

