/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.util.FileUtils;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.util.serializer.SAXSerializer;
import org.exist.xmldb.EXistResource;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class XMLDBStore
extends XMLDBAbstractCollectionManipulator {
    protected static final Logger logger = LogManager.getLogger(XMLDBStore.class);
    protected static final FunctionParameterSequenceType ARG_COLLECTION = new FunctionParameterSequenceType("collection-uri", 22, 2, "The collection URI");
    protected static final FunctionParameterSequenceType ARG_RESOURCE_NAME = new FunctionParameterSequenceType("resource-name", 22, 3, "The resource name");
    protected static final FunctionParameterSequenceType ARG_CONTENTS = new FunctionParameterSequenceType("contents", 11, 2, "The contents");
    protected static final FunctionParameterSequenceType ARG_MIME_TYPE = new FunctionParameterSequenceType("mime-type", 22, 2, "The mime type");
    protected static final FunctionReturnSequenceType RETURN_TYPE = new FunctionReturnSequenceType(22, 3, "the path to new resource if sucessfully stored, otherwise the emtpty sequence");
    protected static final Properties SERIALIZATION_PROPERTIES = new Properties();
    public static final FunctionSignature[] signatures;

    public XMLDBStore(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        Resource resource;
        block28: {
            MimeType mime;
            boolean binary;
            String docName;
            String string = docName = args[1].isEmpty() ? null : args[1].getStringValue();
            if (docName != null && docName.length() == 0) {
                docName = null;
            } else if (docName != null) {
                docName = new AnyURIValue(docName).toXmldbURI().toString();
            }
            Item item = args[2].itemAt(0);
            String mimeType = MimeType.XML_TYPE.getName();
            boolean bl = binary = !Type.subTypeOf(item.getType(), -1);
            if (this.getSignature().getArgumentCount() == 4) {
                mimeType = args[3].getStringValue();
                mime = MimeTable.getInstance().getContentType(mimeType);
                if (mime != null) {
                    binary = !mime.isXMLType();
                }
            } else if (docName != null && (mime = MimeTable.getInstance().getContentTypeFor(docName)) != null) {
                mimeType = mime.getName();
                boolean bl2 = binary = !mime.isXMLType();
            }
            if (this.getSignature().getName().getLocalPart().equals("store-as-binary")) {
                binary = true;
            }
            try {
                if (Type.subTypeOf(item.getType(), 100)) {
                    Object obj = ((JavaObjectValue)item).getObject();
                    if (obj instanceof File) {
                        resource = this.loadFromFile(collection, ((File)obj).toPath(), docName, binary, mimeType);
                        break block28;
                    }
                    if (obj instanceof Path) {
                        resource = this.loadFromFile(collection, (Path)obj, docName, binary, mimeType);
                        break block28;
                    }
                    logger.error("Passed java object should be either a java.nio.file.Path or java.io.File");
                    throw new XPathException((Expression)this, "Passed java object should be either a java.nio.file.Path or java.io.File");
                }
                if (Type.subTypeOf(item.getType(), 25)) {
                    try {
                        URI uri = new URI(item.getStringValue());
                        resource = this.loadFromURI(collection, uri, docName, binary, mimeType);
                        break block28;
                    }
                    catch (URISyntaxException e) {
                        logger.error("Invalid URI: " + item.getStringValue());
                        throw new XPathException((Expression)this, "Invalid URI: " + item.getStringValue(), (Throwable)e);
                    }
                }
                resource = binary ? collection.createResource(docName, "BinaryResource") : collection.createResource(docName, "XMLResource");
                if (Type.subTypeOf(item.getType(), 22)) {
                    resource.setContent((Object)item.getStringValue());
                } else if (item.getType() == 26) {
                    resource.setContent(((BinaryValue)item).toJavaObject());
                } else if (Type.subTypeOf(item.getType(), -1)) {
                    if (binary) {
                        StringWriter writer = new StringWriter();
                        SAXSerializer serializer = new SAXSerializer();
                        serializer.setOutput(writer, null);
                        item.toSAX(this.context.getBroker(), serializer, SERIALIZATION_PROPERTIES);
                        resource.setContent((Object)writer.toString());
                    } else {
                        ContentHandler handler = ((XMLResource)resource).setContentAsSAX();
                        handler.startDocument();
                        item.toSAX(this.context.getBroker(), handler, SERIALIZATION_PROPERTIES);
                        handler.endDocument();
                    }
                } else {
                    logger.error("Data should be either a node or a string");
                    throw new XPathException((Expression)this, "Data should be either a node or a string");
                }
                ((EXistResource)resource).setMimeType(mimeType);
                collection.storeResource(resource);
            }
            catch (XMLDBException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new XPathException((Expression)this, "XMLDB reported an exception while storing document" + (Object)((Object)e), (Throwable)e);
            }
            catch (SAXException e) {
                logger.error(e.getMessage());
                throw new XPathException((Expression)this, "SAX reported an exception while storing document", (Throwable)e);
            }
        }
        if (resource == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        try {
            return new StringValue(collection.getName() + "/" + resource.getId());
        }
        catch (XMLDBException e) {
            logger.error(e.getMessage());
            throw new XPathException((Expression)this, "XMLDB reported an exception while retrieving the stored document", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource loadFromURI(Collection collection, URI uri, String docName, boolean binary, String mimeType) throws XPathException {
        Resource resource;
        if ("file".equals(uri.getScheme())) {
            String path = uri.getPath();
            if (path == null) {
                throw new XPathException((Expression)this, "Cannot read from URI: " + uri.toASCIIString());
            }
            Path file = Paths.get(path, new String[0]);
            if (!Files.isReadable(file)) {
                throw new XPathException((Expression)this, "Cannot read path: " + path);
            }
            resource = this.loadFromFile(collection, file, docName, binary, mimeType);
        } else {
            Path temp = null;
            try {
                temp = Files.createTempFile("existDBS", ".xml", new FileAttribute[0]);
                try (InputStream is = uri.toURL().openStream();){
                    Files.copy(is, temp, new CopyOption[0]);
                    resource = this.loadFromFile(collection, temp, docName, binary, mimeType);
                }
                finally {
                    if (temp != null) {
                        FileUtils.deleteQuietly(temp);
                    }
                }
            }
            catch (MalformedURLException e) {
                throw new XPathException((Expression)this, "Malformed URL: " + uri.toString(), (Throwable)e);
            }
            catch (IOException e) {
                throw new XPathException((Expression)this, "IOException while reading from URL: " + uri.toString(), (Throwable)e);
            }
        }
        return resource;
    }

    private Resource loadFromFile(Collection collection, Path file, String docName, boolean binary, String mimeType) throws XPathException {
        if (!Files.isDirectory(file, new LinkOption[0])) {
            if (docName == null) {
                docName = FileUtils.fileName(file);
            }
            try {
                Resource resource = binary ? collection.createResource(docName, "BinaryResource") : collection.createResource(docName, "XMLResource");
                ((EXistResource)resource).setMimeType(mimeType);
                resource.setContent((Object)file);
                collection.storeResource(resource);
                return resource;
            }
            catch (XMLDBException e) {
                throw new XPathException((Expression)this, "Could not store file " + file.toAbsolutePath() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        throw new XPathException((Expression)this, file.toAbsolutePath() + " does not point to a file");
    }

    static {
        SERIALIZATION_PROPERTIES.setProperty("expand-xincludes", "no");
        signatures = new FunctionSignature[]{new FunctionSignature(new QName("store", "http://exist-db.org/xquery/xmldb", "xmldb"), "Stores a new resource into the database. The resource is stored  in the collection $collection-uri with the name $resource-name. Collection URIs can be specified either as a simple collection path or an XMLDB URI. The contents $contents, is either a node, an xs:string, a Java file object or an xs:anyURI. A node will be serialized to SAX. It becomes the root node of the new document. If $contents is of type xs:anyURI, the resource is loaded from that URI. Returns the path to the new document if successfully stored, otherwise an XPathException is thrown.", new SequenceType[]{ARG_COLLECTION, ARG_RESOURCE_NAME, ARG_CONTENTS}, RETURN_TYPE), new FunctionSignature(new QName("store", "http://exist-db.org/xquery/xmldb", "xmldb"), "Stores a new resource into the database. The resource is stored  in the collection $collection-uri with the name $resource-name. Collection URIs can be specified either as a simple collection path or an XMLDB URI. The contents $contents, is either a node, an xs:string, a Java file object or an xs:anyURI. A node will be serialized to SAX. It becomes the root node of the new document. If $contents is of type xs:anyURI, the resource is loaded from that URI. The final argument $mime-type is used to specify a mime type.  If the mime-type is not a xml based type, the resource will be stored as a binary resource.Returns the path to the new document if successfully stored, otherwise an XPathException is thrown.", new SequenceType[]{ARG_COLLECTION, ARG_RESOURCE_NAME, ARG_CONTENTS, ARG_MIME_TYPE}, RETURN_TYPE), new FunctionSignature(new QName("store-as-binary", "http://exist-db.org/xquery/xmldb", "xmldb"), "Stores a new resource into the database. The resource is stored  in the collection $collection-uri with the name $resource-name. Collection URIs can be specified either as a simple collection path or an XMLDB URI. The contents $contents, is either a node, an xs:string, a Java file object or an xs:anyURI. A node will be serialized to SAX. It becomes the root node of the new document. If $contents is of type xs:anyURI, the resource is loaded from that URI. Returns the path to the new document if successfully stored, otherwise an XPathException is thrown.", new SequenceType[]{ARG_COLLECTION, ARG_RESOURCE_NAME, ARG_CONTENTS}, RETURN_TYPE)};
    }
}

