/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import java.util.Calendar;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xmldb.EXistResource;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.functions.xmldb.XMLDBCreated;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class XMLDBTouch
extends XMLDBAbstractCollectionManipulator {
    private static final Logger logger = LogManager.getLogger(XMLDBCreated.class);
    private static final QName qnTouch = new QName("touch", "http://exist-db.org/xquery/xmldb", "xmldb");
    private static final SequenceType PARAM_COLLECTION_URI = new FunctionParameterSequenceType("collection-uri", 22, 2, "The collection URI");
    private static final SequenceType PARAM_RESOURCE = new FunctionParameterSequenceType("resource", 22, 2, "The name of the resource in the collection");
    private static final SequenceType RETURN_VAL = new FunctionReturnSequenceType(23, 2, "true if the modification time was updated, false otherwise.");
    public static final FunctionSignature FNS_TOUCH_DOCUMENT_NOW = new FunctionSignature(qnTouch, "Sets the modification time of a resource to the current system time. If not resource does not exist it is not created.", new SequenceType[]{PARAM_COLLECTION_URI, PARAM_RESOURCE}, RETURN_VAL);
    public static final FunctionSignature FNS_TOUCH_DOCUMENT = new FunctionSignature(qnTouch, "Sets the modification time of a resource.  If not resource does not exist it is not created.", new SequenceType[]{PARAM_COLLECTION_URI, PARAM_RESOURCE, new FunctionParameterSequenceType("modification-time", 50, 2, "The modification time to set on the resource")}, RETURN_VAL);

    public XMLDBTouch(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    protected Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        try {
            Date newModificationTime;
            EXistResource resource = (EXistResource)collection.getResource(args[1].getStringValue());
            if (resource == null) {
                return BooleanValue.FALSE;
            }
            if (this.getSignature().getArgumentCount() == 2) {
                newModificationTime = Calendar.getInstance().getTime();
            } else if (this.getSignature().getArgumentCount() == 3) {
                newModificationTime = args[2].toJavaObject(Date.class);
            } else {
                throw new XPathException((Expression)this, "Unrecognised function signature: " + this.getSignature());
            }
            resource.setLastModificationTime(newModificationTime);
            return BooleanValue.TRUE;
        }
        catch (XMLDBException e) {
            logger.error("Failed to set modification time of: " + args[0].getStringValue() + "/" + args[1].getStringValue());
            throw new XPathException((Expression)this, "Failed to set modification time: " + e.getMessage(), (Throwable)e);
        }
    }
}

