/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.pragmas;

import org.exist.dom.QName;
import org.exist.xquery.DefaultExpressionVisitor;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.GeneralComparison;
import org.exist.xquery.IndexUseReporter;
import org.exist.xquery.Pragma;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;

public class ForceIndexUse
extends Pragma {
    Expression expression;
    boolean bailout = true;
    public static final QName EXCEPTION_IF_INDEX_NOT_USED_PRAGMA = new QName("force-index-use", "http://exist.sourceforge.net/NS/exist", "exist");

    public ForceIndexUse(QName qname, String contents) throws XPathException {
        super(qname, contents);
    }

    @Override
    public void before(XQueryContext context, Expression expression, Sequence contextSequence) throws XPathException {
    }

    @Override
    public void after(XQueryContext context, Expression expression) throws XPathException {
        expression.accept(new DefaultExpressionVisitor(){

            @Override
            public void visitGeneralComparison(GeneralComparison expression) {
                ForceIndexUse.this.bailout = !expression.hasUsedIndex();
            }

            @Override
            public void visitBuiltinFunction(Function expression) {
                if (expression instanceof IndexUseReporter) {
                    ForceIndexUse.this.bailout = !((IndexUseReporter)((Object)expression)).hasUsedIndex();
                }
            }
        });
        if (this.bailout) {
            throw new XPathException(expression, "XQDYxxxx: Can not use index on expression '" + expression + "'");
        }
    }
}

