/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.update;

import org.exist.EXistException;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.NodeListImpl;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.NodeImpl;
import org.exist.dom.persistent.StoredNode;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.NotificationService;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.update.Modification;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.util.Messages;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;
import org.w3c.dom.NodeList;

public class Insert
extends Modification {
    public static final int INSERT_BEFORE = 0;
    public static final int INSERT_AFTER = 1;
    public static final int INSERT_APPEND = 2;
    private int mode = 0;

    public Insert(XQueryContext context, Expression select, Expression value, int mode) {
        super(context, select, value);
        this.mode = mode;
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence contentSeq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((contentSeq = this.value.eval(contextSequence)).isEmpty()) {
            throw new XPathException((Expression)this, Messages.getMessage("D09"));
        }
        Sequence inSeq = this.select.eval(contextSequence);
        if (!Type.subTypeOf(inSeq.getItemType(), -1)) {
            ValueSequence prevUpdateErrors = null;
            XPathException xpe = new XPathException((Expression)this, Messages.getMessage("D08"));
            Object ctxVarObj = this.context.getXQueryContextVar("_eXist_xquery_update_error");
            prevUpdateErrors = ctxVarObj == null ? new ValueSequence() : (ValueSequence)XPathUtil.javaObjectToXPath(ctxVarObj, this.context);
            prevUpdateErrors.add(new StringValue(xpe.getMessage()));
            this.context.setXQueryContextVar("_eXist_xquery_update_error", prevUpdateErrors);
            if (!inSeq.isEmpty()) {
                throw xpe;
            }
        }
        if (!inSeq.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found: " + inSeq.getItemCount() + " nodes");
            }
            this.context.pushInScopeNamespaces();
            contentSeq = this.deepCopy(contentSeq);
            try (Txn transaction = this.getTransaction();){
                StoredNode[] ql = this.selectAndLock(transaction, inSeq);
                NotificationService notifier = this.context.getBroker().getBrokerPool().getNotificationService();
                NodeList contentList = this.seq2nodeList(contentSeq);
                for (StoredNode node : ql) {
                    DocumentImpl doc = node.getOwnerDocument();
                    if (!doc.getPermissions().validate(this.context.getSubject(), 2)) {
                        throw new PermissionDeniedException("User '" + this.context.getSubject().getName() + "' does not have permission to write to the document '" + doc.getDocumentURI() + "'!");
                    }
                    if (this.mode == 2) {
                        node.appendChildren(transaction, contentList, -1);
                    } else {
                        NodeImpl parent = (NodeImpl)node.getParentNode();
                        switch (this.mode) {
                            case 0: {
                                parent.insertBefore(transaction, contentList, node);
                                break;
                            }
                            case 1: {
                                parent.insertAfter(transaction, contentList, node);
                            }
                        }
                    }
                    doc.getMetadata().setLastModified(System.currentTimeMillis());
                    this.modifiedDocuments.add(doc);
                    this.context.getBroker().storeXMLResource(transaction, doc);
                    notifier.notifyUpdate(doc, 1);
                }
                this.finishTriggers(transaction);
                transaction.commit();
            }
            catch (EXistException | TriggerException | PermissionDeniedException | LockException e) {
                throw new XPathException((Expression)this, e.getMessage(), (Throwable)e);
            }
            finally {
                this.unlockDocuments();
                this.context.popInScopeNamespaces();
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", Sequence.EMPTY_SEQUENCE);
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    private NodeList seq2nodeList(Sequence contentSeq) throws XPathException {
        NodeListImpl nl = new NodeListImpl();
        SequenceIterator i = contentSeq.iterate();
        while (i.hasNext()) {
            Item item = i.nextItem();
            if (!Type.subTypeOf(item.getType(), -1)) continue;
            NodeValue val = (NodeValue)item;
            nl.add(val.getNode());
        }
        return nl;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("update insert").nl();
        dumper.startIndent();
        this.value.dump(dumper);
        dumper.endIndent();
        switch (this.mode) {
            case 1: {
                dumper.display(" following ");
                break;
            }
            case 0: {
                dumper.display(" preceding ");
                break;
            }
            case 2: {
                dumper.display("into");
            }
        }
        dumper.startIndent();
        this.select.dump(dumper);
        dumper.nl().endIndent();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("update insert ");
        result.append(this.value.toString());
        switch (this.mode) {
            case 1: {
                result.append(" following ");
                break;
            }
            case 0: {
                result.append(" preceding ");
                break;
            }
            case 2: {
                result.append(" into ");
            }
        }
        result.append(this.select.toString());
        return result.toString();
    }
}

