/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.update;

import org.exist.EXistException;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.QName;
import org.exist.dom.persistent.AttrImpl;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.ElementImpl;
import org.exist.dom.persistent.NodeImpl;
import org.exist.dom.persistent.StoredNode;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.NotificationService;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.update.Modification;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.util.Messages;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class Rename
extends Modification {
    public Rename(XQueryContext context, Expression select, Expression value) {
        super(context, select, value);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence contentSeq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((contentSeq = this.value.eval(contextSequence)).isEmpty()) {
            throw new XPathException((Expression)this, Messages.getMessage("D09"));
        }
        Sequence inSeq = this.select.eval(contextSequence);
        if (!Type.subTypeOf(inSeq.getItemType(), -1)) {
            ValueSequence prevUpdateErrors = null;
            XPathException xpe = new XPathException((Expression)this, Messages.getMessage("D08"));
            Object ctxVarObj = this.context.getXQueryContextVar("_eXist_xquery_update_error");
            prevUpdateErrors = ctxVarObj == null ? new ValueSequence() : (ValueSequence)XPathUtil.javaObjectToXPath(ctxVarObj, this.context);
            prevUpdateErrors.add(new StringValue(xpe.getMessage()));
            this.context.setXQueryContextVar("_eXist_xquery_update_error", prevUpdateErrors);
            if (!inSeq.isEmpty()) {
                throw xpe;
            }
        }
        if (!inSeq.isEmpty()) {
            QName newQName;
            Item item = contentSeq.itemAt(0);
            if (item.getType() == 24) {
                newQName = ((QNameValue)item).getQName();
            } else {
                try {
                    newQName = QName.parse(this.context, item.getStringValue());
                }
                catch (QName.IllegalQNameException iqe) {
                    throw new XPathException((Expression)this, ErrorCodes.XPST0081, "No namespace defined for prefix " + item.getStringValue());
                }
            }
            try (Txn transaction = this.getTransaction();){
                StoredNode[] ql = this.selectAndLock(transaction, inSeq);
                NotificationService notifier = this.context.getBroker().getBrokerPool().getNotificationService();
                for (StoredNode node : ql) {
                    DocumentImpl doc = node.getOwnerDocument();
                    if (!doc.getPermissions().validate(this.context.getSubject(), 2)) {
                        throw new PermissionDeniedException("User '" + this.context.getSubject().getName() + "' does not have permission to write to the document '" + doc.getDocumentURI() + "'!");
                    }
                    switch (node.getNodeType()) {
                        case 1: {
                            ElementImpl newElem = new ElementImpl((ElementImpl)node);
                            newElem.setNodeName(newQName, this.context.getBroker().getBrokerPool().getSymbols());
                            NodeImpl parent = (NodeImpl)node.getParentNode();
                            parent.updateChild(transaction, node, newElem);
                            break;
                        }
                        case 2: {
                            AttrImpl newAttr = new AttrImpl((AttrImpl)node);
                            newAttr.setNodeName(newQName, this.context.getBroker().getBrokerPool().getSymbols());
                            NodeImpl parent = (NodeImpl)((Object)((AttrImpl)node).getOwnerElement());
                            parent.updateChild(transaction, node, newAttr);
                            break;
                        }
                        default: {
                            throw new XPathException((Expression)this, "unsupported node-type");
                        }
                    }
                    doc.getMetadata().setLastModified(System.currentTimeMillis());
                    this.modifiedDocuments.add(doc);
                    this.context.getBroker().storeXMLResource(transaction, doc);
                    notifier.notifyUpdate(doc, 1);
                }
                this.finishTriggers(transaction);
                transaction.commit();
            }
            catch (EXistException | TriggerException | PermissionDeniedException | LockException e) {
                throw new XPathException((Expression)this, e.getMessage(), (Throwable)e);
            }
            finally {
                this.unlockDocuments();
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", Sequence.EMPTY_SEQUENCE);
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("update rename").nl();
        dumper.startIndent();
        this.select.dump(dumper);
        dumper.endIndent();
        dumper.nl().display(" to ").nl();
        dumper.startIndent();
        this.value.dump(dumper);
        dumper.nl().endIndent();
    }

    public String toString() {
        return "update rename " + this.select.toString() + " as " + this.value.toString();
    }
}

