/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.memtree.SAXAdapter;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.NodeProxy;
import org.exist.security.PermissionDeniedException;
import org.exist.source.SourceFactory;
import org.exist.source.URLSource;
import org.exist.storage.BrokerPool;
import org.exist.storage.lock.Lock;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class DocUtils {
    protected static final Logger LOG = LogManager.getLogger(DocUtils.class);

    public static Sequence getDocument(XQueryContext context, String path) throws XPathException, PermissionDeniedException {
        return DocUtils.getDocumentByPath(context, path);
    }

    public static boolean isDocumentAvailable(XQueryContext context, String path) throws XPathException {
        try {
            Sequence seq = DocUtils.getDocumentByPath(context, path);
            return seq != null && seq.effectiveBooleanValue();
        }
        catch (PermissionDeniedException e) {
            return false;
        }
    }

    private static Sequence getDocumentByPath(XQueryContext context, String path) throws XPathException, PermissionDeniedException {
        if (path.matches("^[a-z]+:.*") && !path.startsWith("xmldb:")) {
            return DocUtils.getDocumentByPathFromURL(context, path);
        }
        return DocUtils.getDocumentByPathFromDB(context, path);
    }

    /*
     * Unable to fully structure code
     */
    private static Sequence getDocumentByPathFromURL(XQueryContext context, String path) throws XPathException, PermissionDeniedException {
        block33: {
            block34: {
                block30: {
                    block31: {
                        block32: {
                            reader = null;
                            source = SourceFactory.getSource(context.getBroker(), "", path, false);
                            is = source.getInputStream();
                            var5_9 = null;
                            if (!(source instanceof URLSource)) ** GOTO lbl30
                            responseCode = ((URLSource)source).getResponseCode();
                            if (responseCode != 404) break block30;
                            var7_13 = Sequence.EMPTY_SEQUENCE;
                            if (is == null) break block31;
                            if (var5_9 == null) break block32;
                            try {
                                is.close();
                            }
                            catch (Throwable var8_15) {
                                var5_9.addSuppressed(var8_15);
                            }
                            break block31;
                        }
                        is.close();
                    }
                    if (reader != null) {
                        context.getBroker().getBrokerPool().getParserPool().returnXMLReader(reader);
                    }
                    return var7_13;
                }
                if (responseCode != 200) {
                    throw new PermissionDeniedException("Server returned code " + responseCode);
                }
lbl30:
                // 3 sources

                memtreeDoc = null;
                reader = context.getBroker().getBrokerPool().getParserPool().borrowXMLReader();
                src = new InputSource(is);
                adapter = new SAXAdapter();
                reader.setContentHandler(adapter);
                reader.parse(src);
                memtreeDoc = doc = adapter.getDocument();
                memtreeDoc.setContext(context);
                memtreeDoc.setDocumentURI(path);
                var10_18 = memtreeDoc;
                if (is == null) break block33;
                if (var5_9 == null) break block34;
                try {
                    is.close();
                }
                catch (Throwable var11_19) {
                    var5_9.addSuppressed(var11_19);
                }
                break block33;
            }
            is.close();
        }
        if (reader != null) {
            context.getBroker().getBrokerPool().getParserPool().returnXMLReader(reader);
        }
        return var10_18;
        {
            catch (Throwable var6_12) {
                try {
                    try {
                        try {
                            var5_9 = var6_12;
                            throw var6_12;
                        }
                        catch (Throwable var12_20) {
                            if (is != null) {
                                if (var5_9 != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable var13_21) {
                                        var5_9.addSuppressed(var13_21);
                                    }
                                } else {
                                    is.close();
                                }
                            }
                            throw var12_20;
                        }
                    }
                    catch (ConnectException e) {
                        throw new XPathException(e.getMessage() + " (" + path + ")");
                    }
                    catch (MalformedURLException e) {
                        throw new XPathException(e.getMessage(), (Throwable)e);
                    }
                    catch (SAXException e) {
                        throw new XPathException("An error occurred while parsing " + path + ": " + e.getMessage(), (Throwable)e);
                    }
                    catch (IOException e) {
                        if (e instanceof FileNotFoundException) {
                            var4_8 = Sequence.EMPTY_SEQUENCE;
                            return var4_8;
                        }
                        throw new XPathException("An error occurred while parsing " + path + ": " + e.getMessage(), (Throwable)e);
                    }
                }
                finally {
                    if (reader != null) {
                        context.getBroker().getBrokerPool().getParserPool().returnXMLReader(reader);
                    }
                }
            }
        }
    }

    private static Sequence getDocumentByPathFromDB(XQueryContext context, String path) throws XPathException, PermissionDeniedException {
        Lock.LockMode lockType = context.lockDocumentsOnLoad() ? Lock.LockMode.WRITE_LOCK : Lock.LockMode.READ_LOCK;
        DocumentImpl doc = null;
        try {
            XmldbURI pathUri = XmldbURI.xmldbUriFor(path, false);
            XmldbURI baseURI = context.getBaseURI().toXmldbURI();
            if (baseURI != null && !baseURI.equals("") && !baseURI.equals("/db")) {
                pathUri = baseURI.resolveCollectionPath(pathUri);
            }
            try {
                pathUri = XmldbURI.xmldbUriFor(context.getModuleLoadPath()).resolveCollectionPath(pathUri);
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
            doc = context.getBroker().getXMLResource(pathUri, lockType);
            if (doc == null) {
                Sequence sequence = Sequence.EMPTY_SEQUENCE;
                return sequence;
            }
            if (!doc.getPermissions().validate(context.getSubject(), 4)) {
                throw new PermissionDeniedException("Insufficient privileges to read resource " + path);
            }
            if (doc.getResourceType() == 1) {
                throw new XPathException("Document " + path + " is a binary resource, not an XML document. Please consider using the function util:binary-doc() to retrieve a reference to it.");
            }
            NodeProxy nodeProxy = new NodeProxy(doc);
            return nodeProxy;
        }
        catch (URISyntaxException e) {
            throw new XPathException(e);
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(lockType);
            }
        }
    }

    public static org.exist.dom.memtree.DocumentImpl parse(XQueryContext context, InputStream is) throws XPathException {
        return DocUtils.parse(context.getBroker().getBrokerPool(), context, is);
    }

    public static org.exist.dom.memtree.DocumentImpl parse(BrokerPool pool, XQueryContext context, InputStream is) throws XPathException {
        XMLReader reader = pool.getParserPool().borrowXMLReader();
        InputSource src = new InputSource(is);
        SAXAdapter adapter = new SAXAdapter(context);
        reader.setContentHandler(adapter);
        try {
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", adapter);
            reader.parse(src);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new XPathException("Error creating XML parser: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException | SAXException e) {
            throw new XPathException("Error while parsing XML: " + e.getMessage(), (Throwable)e);
        }
        return adapter.getDocument();
    }
}

