/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.util;

import org.exist.xquery.XPathException;
import org.exist.xquery.util.NumberFormatter_en;

public abstract class NumberFormatter {
    private static int[] zeroDigits = new int[]{48, 1632, 1776, 2406, 2534, 2662, 2790, 2918, 3046, 3174, 3302, 3430, 3664, 3792, 3872, 4160, 6112, 6160, 6470, 6608, 65296, 66720, 67534, 67544, 67554, 67564, 67574};
    private static char OPTIONAL_DIGIT_SIGN = (char)35;
    public static final NumberFormatter DEFAULT_FORMATTER = new NumberFormatter_en();

    public static int getZeroDigit(int val) {
        for (int z = 0; z < zeroDigits.length; ++z) {
            if (val > zeroDigits[z] + 9) continue;
            if (val >= zeroDigits[z]) {
                return zeroDigits[z];
            }
            return -1;
        }
        return -1;
    }

    public abstract String getMonth(int var1);

    public abstract String getDay(int var1);

    public abstract String getAmPm(int var1);

    public abstract String getOrdinalSuffix(long var1);

    public String formatNumber(long number, String picture) throws XPathException {
        int min = NumberFormatter.getMinDigits(picture);
        int max = NumberFormatter.getMaxDigits(picture);
        return this.formatNumber(number, picture, min, max);
    }

    public String formatNumber(long number, String picture, int min, int max) throws XPathException {
        if (picture == null) {
            return "" + number;
        }
        boolean ordinal = false;
        if (picture.endsWith("o")) {
            ordinal = true;
            picture = picture.substring(0, picture.length() - 1);
        } else if (picture.endsWith("c")) {
            picture = picture.substring(0, picture.length() - 1);
        }
        StringBuilder sb = new StringBuilder();
        int digitSign = this.getFirstDigit(picture);
        int zero = NumberFormatter.getZeroDigit(digitSign);
        int count = 0;
        for (long n = number; n > 0L; n /= 10L) {
            int digit = zero + (int)n % 10;
            sb.insert(0, (char)digit);
            if (++count == max) break;
        }
        if (sb.length() < min) {
            for (int i = sb.length(); i < min; ++i) {
                sb.insert(0, (char)zero);
            }
        }
        if (ordinal) {
            sb.append(this.getOrdinalSuffix(number));
        }
        return sb.toString();
    }

    private int getFirstDigit(String picture) throws XPathException {
        for (int i = 0; i < picture.length(); ++i) {
            char ch = picture.charAt(i);
            if (ch == OPTIONAL_DIGIT_SIGN) continue;
            return ch;
        }
        throw new XPathException("There should be at least one digit sign in the picture string: " + picture);
    }

    public static int getMinDigits(String picture) {
        char ch;
        int count = 0;
        for (int i = 0; i < picture.length() && ((ch = picture.charAt(i)) != 'o' && ch != 'c' || i != picture.length() - 1); ++i) {
            if (ch == OPTIONAL_DIGIT_SIGN) continue;
            ++count;
        }
        return count;
    }

    public static int getMaxDigits(String picture) {
        char ch;
        int count = 0;
        for (int i = 0; i < picture.length() && ((ch = picture.charAt(i)) != 'o' && ch != 'c' || i != picture.length() - 1); ++i) {
            ++count;
        }
        return count;
    }

    public static NumberFormatter getInstance(String language) {
        String className = NumberFormatter.class.getName() + "_" + language;
        try {
            Class<?> langClass = Class.forName(className);
            return (NumberFormatter)langClass.newInstance();
        }
        catch (Exception e) {
            return DEFAULT_FORMATTER;
        }
    }
}

