/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import org.exist.stax.ExtendedXMLStreamReader;
import org.exist.xquery.Cardinality;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.functions.fn.FnModule;
import org.exist.xquery.functions.map.MapType;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.DecimalValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.StringValue;

public class SerializerUtils {
    public static final Map<String, ParameterConvention> PARAMETER_CONVENTIONS_BY_NAME = new HashMap<String, ParameterConvention>();

    public static void getSerializationOptions(Expression parent, NodeValue parameters, Properties properties) throws XPathException {
        try {
            ExtendedXMLStreamReader reader = parent.getContext().getXMLStreamReader(parameters);
            while (reader.hasNext() && reader.next() != 1) {
            }
            if (!"http://www.w3.org/2010/xslt-xquery-serialization".equals(reader.getNamespaceURI())) {
                throw new XPathException(parent, FnModule.SENR0001, "serialization parameter elements should be in the output namespace");
            }
            while (reader.hasNext()) {
                int status = reader.next();
                if (status != 1) continue;
                String key = reader.getLocalName();
                if (properties.contains(key)) {
                    throw new XPathException(parent, FnModule.SEPM0019, "serialization parameter specified twice: " + key);
                }
                String value = reader.getAttributeValue("", "value");
                if (value == null) {
                    value = reader.getElementText();
                }
                properties.put(key, value);
            }
        }
        catch (IOException | XMLStreamException e) {
            throw new XPathException(parent, ErrorCodes.EXXQDY0001, e.getMessage());
        }
    }

    public static Properties getSerializationOptions(Expression parent, MapType entries) throws XPathException {
        try {
            Properties properties = new Properties();
            for (ParameterConvention parameterConvention : ParameterConvention.values()) {
                Sequence parameterValue;
                Sequence providedParameterValue = entries.get(new StringValue(parameterConvention.parameterName));
                if (providedParameterValue == null || providedParameterValue.isEmpty() || parameterConvention.type == 22 && SerializerUtils.isEmptyStringValue(providedParameterValue)) {
                    parameterValue = ParameterConvention.MEDIA_TYPE == parameterConvention ? SerializerUtils.getDefaultMediaType(entries.get(new StringValue(ParameterConvention.METHOD.parameterName))) : parameterConvention.defaultValue;
                } else if (SerializerUtils.checkTypes(parameterConvention, providedParameterValue)) {
                    parameterValue = providedParameterValue;
                } else {
                    throw new XPathException(parent, ErrorCodes.XPTY0004, "The supplied value is of the wrong type for the particular parameter: " + parameterConvention.parameterName);
                }
                SerializerUtils.setPropertyForMap(properties, parameterConvention, parameterValue);
            }
            return properties;
        }
        catch (UnsupportedOperationException e) {
            throw new XPathException(parent, FnModule.SENR0001, e.getMessage());
        }
    }

    private static Sequence getDefaultMediaType(Sequence providedMethod) throws XPathException {
        String method;
        Sequence methodValue = providedMethod == null || providedMethod.isEmpty() ? ParameterConvention.METHOD.defaultValue : providedMethod;
        switch (method = methodValue.itemAt(0).getStringValue().toLowerCase()) {
            case "xml": 
            case "microxml": {
                return new StringValue("application/xml");
            }
            case "xhtml": {
                return new StringValue("application/xhtml+xml");
            }
            case "adaptive": {
                return new StringValue("text/plain");
            }
            case "json": {
                return new StringValue("application/json");
            }
            case "jsonp": {
                return new StringValue("application/javascript");
            }
            case "html": {
                return new StringValue("text/html");
            }
            case "text": {
                return new StringValue("text/plain");
            }
            case "binary": {
                return new StringValue("application/octet-stream");
            }
        }
        throw new UnsupportedOperationException("Unrecognised serialization method: " + method);
    }

    private static boolean checkTypes(ParameterConvention parameterConvention, Sequence sequence) throws XPathException {
        if (Cardinality.checkCardinality(parameterConvention.cardinality, sequence.getCardinality())) {
            SequenceIterator iterator = sequence.iterate();
            while (iterator.hasNext()) {
                Item item = iterator.nextItem();
                if (parameterConvention.type == item.getType()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static void setPropertyForMap(Properties properties, ParameterConvention parameterConvention, Sequence parameterValue) throws XPathException {
        if (23 == parameterConvention.type) {
            if (!parameterValue.isEmpty()) {
                if (((BooleanValue)parameterValue.itemAt(0)).getValue()) {
                    properties.setProperty(parameterConvention.parameterName, "yes");
                } else {
                    properties.setProperty(parameterConvention.parameterName, "no");
                }
            }
        } else if (22 == parameterConvention.type) {
            if (!parameterValue.isEmpty()) {
                properties.setProperty(parameterConvention.parameterName, ((StringValue)parameterValue.itemAt(0)).getStringValue());
            }
        } else if (32 == parameterConvention.type) {
            properties.setProperty(parameterConvention.parameterName, ((DecimalValue)parameterValue.itemAt(0)).getStringValue());
        } else if (24 == parameterConvention.type) {
            if (!parameterValue.isEmpty()) {
                if (Cardinality.checkCardinality(4, parameterConvention.cardinality)) {
                    String existingValue = (String)properties.get(parameterConvention.parameterName);
                    if (existingValue == null || existingValue.isEmpty()) {
                        properties.setProperty(parameterConvention.parameterName, ((QNameValue)parameterValue.itemAt(0)).getStringValue());
                    } else {
                        properties.setProperty(parameterConvention.parameterName, existingValue + " " + ((QNameValue)parameterValue.itemAt(0)).getStringValue());
                    }
                } else {
                    properties.setProperty(parameterConvention.parameterName, ((QNameValue)parameterValue.itemAt(0)).getStringValue());
                }
            }
        } else if (102 == parameterConvention.type && !parameterValue.isEmpty()) {
            throw new UnsupportedOperationException("Not yet implemented support for the map serialization parameter: " + parameterConvention.parameterName);
        }
    }

    private static boolean isEmptyStringValue(Sequence sequence) {
        if (sequence != null && sequence.getItemCount() == 1) {
            Item firstItem = sequence.itemAt(0);
            return 22 == firstItem.getType() && ((StringValue)firstItem).getStringValue().isEmpty();
        }
        return false;
    }

    static {
        for (ParameterConvention parameterConvention : ParameterConvention.values()) {
            PARAMETER_CONVENTIONS_BY_NAME.put(parameterConvention.parameterName, parameterConvention);
        }
    }

    public static enum ParameterConvention {
        ALLOW_DUPLICATE_NAMES("allow-duplicate-names", 23, 3, BooleanValue.FALSE),
        BYTE_ORDER_MARK("byte-order-mark", 23, 3, BooleanValue.FALSE),
        CDATA_SECTION_ELEMENTS("cdata-section-elements", 24, 7, Sequence.EMPTY_SEQUENCE),
        DOCTYPE_PUBLIC("doctype-public", 22, 3, Sequence.EMPTY_SEQUENCE),
        DOCTYPE_SYSTEM("doctype-system", 22, 3, Sequence.EMPTY_SEQUENCE),
        ENCODING("encoding", 22, 3, new StringValue("utf-8")),
        ESCAPE_URI_ATTRIBUTES("escape-uri-attributes", 23, 3, BooleanValue.TRUE),
        HTML_VERSION("html-version", 32, 3, new DecimalValue(5.0)),
        INCLUDE_CONTENT_TYPE("include-content-type", 23, 3, BooleanValue.TRUE),
        INDENT("indent", 23, 3, BooleanValue.FALSE),
        ITEM_SEPARATOR("item-separator", 22, 3, Sequence.EMPTY_SEQUENCE),
        JSON_NODE_OUTPUT_METHOD("json-node-output-method", 22, 3, new StringValue("xml")),
        MEDIA_TYPE("media-type", 22, 3, Sequence.EMPTY_SEQUENCE),
        METHOD("method", 22, 3, new StringValue("xml")),
        NORMALIZATION_FORM("normalization-form", 22, 3, new StringValue("none")),
        OMIT_XML_DECLARATION("omit-xml-declaration", 23, 3, BooleanValue.TRUE),
        STANDALONE("standalone", 23, 3, Sequence.EMPTY_SEQUENCE),
        SUPPRESS_INDENTATION("suppress-indentation", 24, 7, Sequence.EMPTY_SEQUENCE),
        UNDECLARE_PREFIXES("undeclare-prefixes", 23, 3, BooleanValue.FALSE),
        USE_CHARACTER_MAPS("use-character-maps", 102, 3, Sequence.EMPTY_SEQUENCE),
        VERSION("version", 22, 3, new StringValue("1.0"));

        final String parameterName;
        final int type;
        final int cardinality;
        final Sequence defaultValue;

        private ParameterConvention(String parameterName, int type, int cardinality, Sequence defaultValue) {
            this.parameterName = parameterName;
            this.type = type;
            this.cardinality = cardinality;
            this.defaultValue = defaultValue;
        }
    }
}

