/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import com.ibm.icu.text.Collator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xerces.util.DatatypeMessageFormatter;
import org.exist.xquery.Constants;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DateValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.TimeUtils;
import org.exist.xquery.value.Type;

public abstract class AbstractDateTimeValue
extends ComputableValue {
    public static final int YEAR = 0;
    public static final int MONTH = 1;
    public static final int DAY = 2;
    public static final int HOUR = 3;
    public static final int MINUTE = 4;
    public static final int SECOND = 5;
    public static final int MILLISECOND = 6;
    protected static final Pattern negativeDateStart = Pattern.compile("^\\d\\d?-(\\d+)-(.*)");
    protected static final short[] monthData = new short[]{306, 337, 0, 31, 61, 92, 122, 153, 184, 214, 245, 275};
    private static final Logger LOG = LogManager.getLogger(AbstractDateTimeValue.class);
    private static final Duration tzLowerBound = TimeUtils.getInstance().newDurationDayTime("-PT14H");
    private static final Duration tzUpperBound = tzLowerBound.negate();
    protected static byte[] daysPerMonth = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public final XMLGregorianCalendar calendar;
    private XMLGregorianCalendar implicitCalendar;
    private XMLGregorianCalendar canonicalCalendar;
    private XMLGregorianCalendar trimmedCalendar;

    protected AbstractDateTimeValue(XMLGregorianCalendar calendar) {
        this.calendar = calendar;
    }

    protected AbstractDateTimeValue(String lexicalValue) throws XPathException {
        lexicalValue = StringValue.trimWhitespace(lexicalValue);
        try {
            this.calendar = this.parse(lexicalValue);
        }
        catch (IllegalArgumentException e) {
            throw new XPathException(ErrorCodes.FORG0001, "illegal lexical form for date-time-like value '" + lexicalValue + "' " + e.getMessage(), (Throwable)e);
        }
    }

    public static XMLGregorianCalendar cloneXMLGregorianCalendar(XMLGregorianCalendar calendar) {
        boolean hacked = false;
        if (calendar.getYear() == 0) {
            calendar.setYear(1);
            hacked = true;
        }
        XMLGregorianCalendar result = (XMLGregorianCalendar)calendar.clone();
        if (hacked) {
            calendar.setYear(0);
            result.setYear(0);
        }
        return result;
    }

    private static boolean isDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    public static int getJulianDayNumber(int year, int month, int day) {
        int z = year - (month < 3 ? 1 : 0);
        short f = monthData[month - 1];
        if (z >= 0) {
            return day + f + 365 * z + z / 4 - z / 100 + z / 400 + 1721118;
        }
        int j = day + f + 365 * (z += 12000) + z / 4 - z / 100 + z / 400 + 1721118;
        return j - 4382910;
    }

    protected XMLGregorianCalendar getImplicitCalendar() {
        if (this.implicitCalendar == null) {
            this.implicitCalendar = (XMLGregorianCalendar)this.calendar.clone();
            if (this.calendar.getTimezone() == Integer.MIN_VALUE) {
                this.implicitCalendar.setTimezone(TimeUtils.getInstance().getLocalTimezoneOffsetMinutes());
            }
            switch (this.getType()) {
                case 51: {
                    this.implicitCalendar.setTime(0, 0, 0);
                    break;
                }
                case 52: {
                    this.implicitCalendar.setYear(1972);
                    this.implicitCalendar.setMonth(12);
                    this.implicitCalendar.setDay(31);
                    break;
                }
            }
            this.implicitCalendar = this.implicitCalendar.normalize();
        }
        return this.implicitCalendar;
    }

    protected XMLGregorianCalendar getCanonicalCalendar() {
        if (this.canonicalCalendar == null) {
            this.canonicalCalendar = this.getTrimmedCalendar().normalize();
        }
        return this.canonicalCalendar;
    }

    public XMLGregorianCalendar getTrimmedCalendar() {
        if (this.trimmedCalendar == null) {
            this.trimmedCalendar = AbstractDateTimeValue.cloneXMLGregorianCalendar(this.calendar);
            BigDecimal fract = this.trimmedCalendar.getFractionalSecond();
            if (fract != null) {
                int i;
                String s = fract.toString();
                for (i = s.length(); i > 0 && s.charAt(i - 1) == '0'; --i) {
                }
                if (i == 0) {
                    this.trimmedCalendar.setFractionalSecond(null);
                } else if (i != s.length()) {
                    this.trimmedCalendar.setFractionalSecond(new BigDecimal(s.substring(0, i)));
                }
            }
        }
        return this.trimmedCalendar;
    }

    protected XMLGregorianCalendar getCanonicalOrTrimmedCalendar() {
        try {
            return this.getCanonicalCalendar();
        }
        catch (Exception e) {
            return this.getTrimmedCalendar();
        }
    }

    protected abstract AbstractDateTimeValue createSameKind(XMLGregorianCalendar var1) throws XPathException;

    public long getTimeInMillis() {
        return this.getImplicitCalendar().toGregorianCalendar().getTimeInMillis();
    }

    protected abstract QName getXMLSchemaType();

    @Override
    public String getStringValue() throws XPathException {
        Matcher m;
        String r = this.getTrimmedCalendar().toXMLFormat();
        boolean startsWithDashDash = r.startsWith("--");
        r = r.replaceAll("--", "");
        if (startsWithDashDash) {
            r = "--" + r;
        }
        if ((m = negativeDateStart.matcher(r)).matches()) {
            int year = Integer.parseInt(m.group(1));
            DecimalFormat df = new DecimalFormat("0000");
            r = "-" + df.format(year) + "-" + m.group(2);
        }
        return r;
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        throw new XPathException(ErrorCodes.FORG0006, "effective boolean value invalid operand type: " + Type.getTypeName(this.getType()));
    }

    @Override
    public abstract AtomicValue convertTo(int var1) throws XPathException;

    public int getPart(int part) {
        switch (part) {
            case 0: {
                return this.calendar.getYear();
            }
            case 1: {
                return this.calendar.getMonth();
            }
            case 2: {
                return this.calendar.getDay();
            }
            case 3: {
                return this.calendar.getHour();
            }
            case 4: {
                return this.calendar.getMinute();
            }
            case 5: {
                return this.calendar.getSecond();
            }
            case 6: {
                int mSec = this.calendar.getMillisecond();
                if (mSec == Integer.MIN_VALUE) {
                    return 0;
                }
                return this.calendar.getMillisecond();
            }
        }
        throw new IllegalArgumentException("Invalid argument to method getPart");
    }

    protected void validateTimezone(DayTimeDurationValue offset) throws XPathException {
        Duration tz = offset.duration;
        Number secs = tz.getField(DatatypeConstants.SECONDS);
        if (secs != null && ((BigDecimal)secs).compareTo(BigDecimal.valueOf(0L)) != 0) {
            throw new XPathException(ErrorCodes.FODT0003, "duration " + offset + " has fractional minutes so cannot be used as a timezone offset");
        }
        if (!(tz.equals(tzLowerBound) || tz.equals(tzUpperBound) || tz.isLongerThan(tzLowerBound) && tz.isShorterThan(tzUpperBound))) {
            throw new XPathException(ErrorCodes.FODT0003, "duration " + offset + " outside valid timezone offset range");
        }
    }

    public AbstractDateTimeValue adjustedToTimezone(DayTimeDurationValue offset) throws XPathException {
        if (offset == null) {
            offset = new DayTimeDurationValue(TimeUtils.getInstance().getLocalTimezoneOffsetMillis());
        }
        this.validateTimezone(offset);
        XMLGregorianCalendar xgc = (XMLGregorianCalendar)this.calendar.clone();
        if (xgc.getTimezone() != Integer.MIN_VALUE) {
            if (this.getType() == 51) {
                xgc.setTime(0, 0, 0);
            }
            xgc = xgc.normalize();
            xgc.add(offset.duration);
        }
        try {
            xgc.setTimezone((int)(offset.getValue() / 60.0));
        }
        catch (IllegalArgumentException e) {
            throw new XPathException(ErrorCodes.FORG0001, "illegal timezone offset " + offset, (Throwable)e);
        }
        return this.createSameKind(xgc);
    }

    public AbstractDateTimeValue withoutTimezone() throws XPathException {
        XMLGregorianCalendar xgc = (XMLGregorianCalendar)this.calendar.clone();
        xgc.setTimezone(Integer.MIN_VALUE);
        return this.createSameKind(xgc);
    }

    public Sequence getTimezone() throws XPathException {
        int tz = this.calendar.getTimezone();
        if (tz == Integer.MIN_VALUE) {
            return Sequence.EMPTY_SEQUENCE;
        }
        return new DayTimeDurationValue((long)tz * 60000L);
    }

    @Override
    public boolean compareTo(Collator collator, Constants.Comparison operator, AtomicValue other) throws XPathException {
        int cmp = this.compareTo(collator, other);
        switch (operator) {
            case EQ: {
                return cmp == 0;
            }
            case NEQ: {
                return cmp != 0;
            }
            case LT: {
                return cmp < 0;
            }
            case LTEQ: {
                return cmp <= 0;
            }
            case GT: {
                return cmp > 0;
            }
            case GTEQ: {
                return cmp >= 0;
            }
        }
        throw new XPathException("Unknown operator type in comparison");
    }

    @Override
    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == this.getType()) {
            int r = this.getImplicitCalendar().compare(((AbstractDateTimeValue)other).getImplicitCalendar());
            if (r == 2) {
                throw new RuntimeException("indeterminate order between " + this + " and " + other);
            }
            return r;
        }
        throw new XPathException(ErrorCodes.XPTY0004, "Type error: cannot compare " + Type.getTypeName(this.getType()) + " to " + Type.getTypeName(other.getType()));
    }

    @Override
    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        AbstractDateTimeValue otherDate = other.getType() == this.getType() ? (AbstractDateTimeValue)other : (AbstractDateTimeValue)other.convertTo(this.getType());
        return this.getImplicitCalendar().compare(otherDate.getImplicitCalendar()) > 0 ? this : other;
    }

    @Override
    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        AbstractDateTimeValue otherDate = other.getType() == this.getType() ? (AbstractDateTimeValue)other : (AbstractDateTimeValue)other.convertTo(this.getType());
        return this.getImplicitCalendar().compare(otherDate.getImplicitCalendar()) < 0 ? this : other;
    }

    @Override
    public ComputableValue plus(ComputableValue other) throws XPathException {
        switch (other.getType()) {
            case 54: 
            case 55: {
                return other.plus(this);
            }
        }
        throw new XPathException("Operand to plus should be of type xdt:dayTimeDuration or xdt:yearMonthDuration; got: " + Type.getTypeName(other.getType()));
    }

    @Override
    public ComputableValue mult(ComputableValue other) throws XPathException {
        throw new XPathException("multiplication is not supported for type " + Type.getTypeName(this.getType()));
    }

    @Override
    public ComputableValue div(ComputableValue other) throws XPathException {
        throw new XPathException("division is not supported for type " + Type.getTypeName(this.getType()));
    }

    @Override
    public int conversionPreference(Class<?> javaClass) {
        if (javaClass.isAssignableFrom(DateValue.class)) {
            return 0;
        }
        if (javaClass.isAssignableFrom(XMLGregorianCalendar.class)) {
            return 1;
        }
        if (javaClass.isAssignableFrom(GregorianCalendar.class)) {
            return 2;
        }
        if (javaClass == Date.class) {
            return 3;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public <T> T toJavaObject(Class<T> target) throws XPathException {
        if (target == Object.class || target.isAssignableFrom(DateValue.class)) {
            return (T)this;
        }
        if (target.isAssignableFrom(XMLGregorianCalendar.class)) {
            return (T)this.calendar.clone();
        }
        if (target.isAssignableFrom(GregorianCalendar.class)) {
            return (T)this.calendar.toGregorianCalendar();
        }
        if (target == Date.class) {
            return (T)this.calendar.toGregorianCalendar().getTime();
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof AbstractDateTimeValue) {
            AbstractDateTimeValue dt = (AbstractDateTimeValue)o;
            return this.calendar.compare(dt.calendar);
        }
        AtomicValue other = (AtomicValue)o;
        if (Type.subTypeOf(other.getType(), 50)) {
            try {
                return this.calendar.compare(TimeUtils.getInstance().newXMLGregorianCalendar(other.getStringValue()));
            }
            catch (XPathException e) {
                LOG.error("Failed to get string value of '{}'", (Object)other, (Object)e);
                return 1;
            }
        }
        return this.getType() > other.getType() ? 1 : -1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractDateTimeValue) {
            AbstractDateTimeValue dt = (AbstractDateTimeValue)obj;
            return this.calendar.equals(dt.calendar);
        }
        return false;
    }

    public int hashCode() {
        return this.calendar.hashCode();
    }

    public int getDayOfWeek() {
        return this.calendar.toGregorianCalendar().get(7);
    }

    public int getDayWithinYear() {
        int j = AbstractDateTimeValue.getJulianDayNumber(this.calendar.getYear(), this.calendar.getMonth(), this.calendar.getDay());
        int k = AbstractDateTimeValue.getJulianDayNumber(this.calendar.getYear(), 1, 1);
        return j - k + 1;
    }

    public int getWeekWithinYear() {
        return this.calendar.toGregorianCalendar().get(3);
    }

    public int getWeekWithinMonth() {
        return this.calendar.toGregorianCalendar().get(4);
    }

    private XMLGregorianCalendar parse(String lexicalRepresentation) {
        String format = null;
        String lexRep = lexicalRepresentation;
        int NOT_FOUND = -1;
        int lexRepLength = lexRep.length();
        if (lexRep.indexOf(84) != -1) {
            format = "%Y-%M-%DT%h:%m:%s%z";
        } else if (lexRepLength >= 3 && lexRep.charAt(2) == ':') {
            format = "%h:%m:%s%z";
        } else if (lexRep.startsWith("--")) {
            if (lexRepLength >= 3 && lexRep.charAt(2) == '-') {
                format = "---%D%z";
            } else if (lexRepLength == 4 || lexRepLength >= 6 && (lexRep.charAt(4) == '+' || lexRep.charAt(4) == '-' && (lexRep.charAt(5) == '-' || lexRepLength == 10))) {
                format = "--%M--%Z";
                Parser p = new Parser(format, lexRep);
                try {
                    XMLGregorianCalendar c = p.parse();
                    if (!c.isValid()) {
                        throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, (String)"InvalidXGCRepresentation", (Object[])new Object[]{lexicalRepresentation}));
                    }
                    return c;
                }
                catch (IllegalArgumentException e) {
                    format = "--%M%z";
                }
            } else {
                format = "--%M-%D%z";
            }
        } else {
            int countSeparator = 0;
            int timezoneOffset = lexRep.indexOf(58);
            if (timezoneOffset != -1) {
                lexRepLength -= 6;
            }
            for (int i = 1; i < lexRepLength; ++i) {
                if (lexRep.charAt(i) != '-') continue;
                ++countSeparator;
            }
            format = countSeparator == 0 ? "%Y%z" : (countSeparator == 1 ? "%Y-%M%z" : "%Y-%M-%D%z");
        }
        Parser p = new Parser(format, lexRep);
        XMLGregorianCalendar c = p.parse();
        if (!c.isValid()) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, (String)"InvalidXGCRepresentation", (Object[])new Object[]{lexicalRepresentation}));
        }
        return c;
    }

    private final class Parser {
        private final String format;
        private final String value;
        private final int flen;
        private final int vlen;
        private int fidx;
        private int vidx;
        private BigInteger year = null;
        private int month = Integer.MIN_VALUE;
        private int day = Integer.MIN_VALUE;
        private int timezone = Integer.MIN_VALUE;
        private int hour = Integer.MIN_VALUE;
        private int minute = Integer.MIN_VALUE;
        private int second = Integer.MIN_VALUE;
        private BigDecimal fractionalSecond = null;

        private Parser(String format, String value) {
            this.format = format;
            this.value = value;
            this.flen = format.length();
            this.vlen = value.length();
        }

        public XMLGregorianCalendar parse() throws IllegalArgumentException {
            block10: while (this.fidx < this.flen) {
                char fch;
                if ((fch = this.format.charAt(this.fidx++)) != '%') {
                    this.skip(fch);
                    continue;
                }
                switch (this.format.charAt(this.fidx++)) {
                    case 'Y': {
                        this.parseYear();
                        continue block10;
                    }
                    case 'M': {
                        this.month = this.parseInt(2, 2);
                        continue block10;
                    }
                    case 'D': {
                        this.day = this.parseInt(2, 2);
                        continue block10;
                    }
                    case 'h': {
                        this.hour = this.parseInt(2, 2);
                        continue block10;
                    }
                    case 'm': {
                        this.minute = this.parseInt(2, 2);
                        continue block10;
                    }
                    case 's': {
                        this.second = this.parseInt(2, 2);
                        if (this.peek() != '.') continue block10;
                        this.fractionalSecond = this.parseBigDecimal();
                        continue block10;
                    }
                    case 'z': {
                        char vch = this.peek();
                        if (vch == 'Z') {
                            ++this.vidx;
                            this.timezone = 0;
                            continue block10;
                        }
                        if (vch != '+' && vch != '-') continue block10;
                        ++this.vidx;
                        int h = this.parseInt(2, 2);
                        this.skip(':');
                        int m = this.parseInt(2, 2);
                        if (m >= 60 || m < 0) {
                            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, (String)"InvalidFieldValue", (Object[])new Object[]{m, "timezone minutes"}));
                        }
                        this.timezone = (h * 60 + m) * (vch == '+' ? 1 : -1);
                        continue block10;
                    }
                    case 'Z': {
                        int m;
                        int h;
                        char vch = this.peek();
                        if (vch == 'Z') {
                            ++this.vidx;
                            this.timezone = 0;
                            continue block10;
                        }
                        if (vch == '+' || vch == '-') {
                            ++this.vidx;
                            h = this.parseInt(2, 2);
                            this.skip(':');
                            m = this.parseInt(2, 2);
                            if (m >= 60 || m < 0) {
                                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, (String)"InvalidFieldValue", (Object[])new Object[]{m, "timezone minutes"}));
                            }
                            this.timezone = (h * 60 + m) * (vch == '+' ? 1 : -1);
                            continue block10;
                        }
                        throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, (String)"InvalidFieldValue", (Object[])new Object[]{"do not defined", "timezone"}));
                    }
                }
                throw new InternalError();
            }
            if (this.vidx != this.vlen) {
                throw new IllegalArgumentException(this.value);
            }
            if (this.hour == 24 && this.minute == 0 && this.second == 0 && AbstractDateTimeValue.this.getType() == 52) {
                this.hour = 0;
            }
            return TimeUtils.getInstance().getFactory().newXMLGregorianCalendar(this.year, this.month, this.day, this.hour, this.minute, this.second, this.fractionalSecond, this.timezone);
        }

        private char peek() throws IllegalArgumentException {
            if (this.vidx == this.vlen) {
                return '\uffff';
            }
            return this.value.charAt(this.vidx);
        }

        private char read() throws IllegalArgumentException {
            if (this.vidx == this.vlen) {
                throw new IllegalArgumentException(this.value);
            }
            return this.value.charAt(this.vidx++);
        }

        private void skip(char ch) throws IllegalArgumentException {
            if (this.read() != ch) {
                throw new IllegalArgumentException(this.value);
            }
        }

        private void parseYear() throws IllegalArgumentException {
            int vstart = this.vidx++;
            int sign = 0;
            if (this.peek() == '-') {
                sign = 1;
            }
            while (AbstractDateTimeValue.isDigit(this.peek())) {
                ++this.vidx;
            }
            int digits = this.vidx - vstart - sign;
            if (digits < 4) {
                throw new IllegalArgumentException(this.value);
            }
            String yearString = this.value.substring(vstart, this.vidx);
            this.year = new BigInteger(yearString);
        }

        private int parseInt(int minDigits, int maxDigits) throws IllegalArgumentException {
            int vstart = this.vidx;
            while (AbstractDateTimeValue.isDigit(this.peek()) && this.vidx - vstart < maxDigits) {
                ++this.vidx;
            }
            if (this.vidx - vstart < minDigits) {
                throw new IllegalArgumentException(this.value);
            }
            return Integer.parseInt(this.value.substring(vstart, this.vidx));
        }

        private BigDecimal parseBigDecimal() throws IllegalArgumentException {
            int vstart = this.vidx++;
            if (this.peek() != '.') {
                throw new IllegalArgumentException(this.value);
            }
            while (AbstractDateTimeValue.isDigit(this.peek())) {
                ++this.vidx;
            }
            return new BigDecimal(this.value.substring(vstart, this.vidx));
        }
    }
}

