/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exist.collections.Collection;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.EmptyNodeSet;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeProxy;
import org.exist.numbering.NodeId;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public abstract class AbstractSequence
implements Sequence {
    private static final boolean OLD_EXIST_VERSION_COMPATIBILITY = false;
    protected boolean isEmpty = true;
    protected boolean hasOne = false;

    @Override
    public int getCardinality() {
        if (this.isEmpty()) {
            return 1;
        }
        if (this.hasOne()) {
            return 2;
        }
        if (this.hasMany()) {
            return 6;
        }
        throw new IllegalArgumentException("Illegal argument");
    }

    @Override
    public AtomicValue convertTo(int requiredType) throws XPathException {
        Item first = this.itemAt(0);
        if (Type.subTypeOf(first.getType(), 20)) {
            return first.convertTo(requiredType);
        }
        return new StringValue(first.getStringValue()).convertTo(requiredType);
    }

    @Override
    public boolean hasMany() {
        return !this.isEmpty() && !this.hasOne();
    }

    @Override
    public Sequence tail() throws XPathException {
        ValueSequence tmp = new ValueSequence(this.getItemCount() - 1);
        SequenceIterator iterator = this.iterate();
        iterator.nextItem();
        while (iterator.hasNext()) {
            Item item = iterator.nextItem();
            tmp.add(item);
        }
        return tmp;
    }

    @Override
    public String getStringValue() throws XPathException {
        if (this.isEmpty()) {
            return "";
        }
        Item first = this.iterate().nextItem();
        return first.getStringValue();
    }

    public String toString() {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("(");
            boolean gotOne = false;
            SequenceIterator i = this.iterate();
            while (i.hasNext()) {
                if (gotOne) {
                    buf.append(", ");
                }
                buf.append(i.nextItem());
                gotOne = true;
            }
            buf.append(")");
            return buf.toString();
        }
        catch (XPathException e) {
            return "toString() fails: " + e.getMessage();
        }
    }

    @Override
    public void addAll(Sequence other) throws XPathException {
        SequenceIterator i = other.iterate();
        while (i.hasNext()) {
            this.add(i.nextItem());
        }
    }

    @Override
    public DocumentSet getDocumentSet() {
        return DocumentSet.EMPTY_DOCUMENT_SET;
    }

    @Override
    public Iterator<Collection> getCollectionIterator() {
        return EmptyNodeSet.EMPTY_COLLECTION_ITERATOR;
    }

    @Override
    public void nodeMoved(NodeId oldNodeId, NodeHandle newNode) {
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        if (this.isEmpty()) {
            return false;
        }
        Item first = this.itemAt(0);
        if (Type.subTypeOf(first.getType(), -1)) {
            return true;
        }
        if (this.hasMany()) {
            throw new XPathException("err:FORG0006: effectiveBooleanValue: first item of '" + (this.toString().length() < 20 ? this.toString() : this.toString().substring(0, 20) + "...") + "' is not a node, and sequence length > 1");
        }
        return ((AtomicValue)first).effectiveBooleanValue();
    }

    @Override
    public int conversionPreference(Class<?> javaClass) {
        if (javaClass.isAssignableFrom(Sequence.class)) {
            return 0;
        }
        if (javaClass.isAssignableFrom(List.class) || javaClass.isArray()) {
            return 1;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        if (!this.isEmpty()) {
            return this.itemAt(0).conversionPreference(javaClass);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public <T> T toJavaObject(Class<T> target) throws XPathException {
        if (Sequence.class.isAssignableFrom(target)) {
            return (T)this;
        }
        if (target.isArray()) {
            Class<?> componentType = target.getComponentType();
            Object array = Array.newInstance(componentType, this.getItemCount());
            if (!target.isInstance(array)) {
                return null;
            }
            int index = 0;
            SequenceIterator i = this.iterate();
            while (i.hasNext()) {
                Item item = i.nextItem();
                Object obj = item.toJavaObject(componentType);
                Array.set(array, index, obj);
                ++index;
            }
            return (T)array;
        }
        if (target.isAssignableFrom(List.class)) {
            ArrayList<Item> l = new ArrayList<Item>(this.getItemCount());
            SequenceIterator i = this.iterate();
            while (i.hasNext()) {
                l.add(i.nextItem());
            }
            return (T)l;
        }
        if (!this.isEmpty()) {
            return this.itemAt(0).toJavaObject(target);
        }
        return null;
    }

    @Override
    public void clearContext(int contextId) throws XPathException {
        SequenceIterator i = this.unorderedIterator();
        while (i.hasNext()) {
            Item next = i.nextItem();
            if (!(next instanceof NodeProxy)) continue;
            ((NodeProxy)next).clearContext(contextId);
        }
    }

    @Override
    public void setSelfAsContext(int contextId) throws XPathException {
        SequenceIterator i = this.unorderedIterator();
        while (i.hasNext()) {
            Item next = i.nextItem();
            if (!Type.subTypeOf(next.getType(), -1)) continue;
            NodeValue node = (NodeValue)next;
            node.addContextNode(contextId, node);
        }
    }

    @Override
    public boolean isCached() {
        return false;
    }

    @Override
    public void setIsCached(boolean cached) {
    }

    @Override
    public boolean isPersistentSet() {
        return false;
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    @Override
    public int getState() {
        return 0;
    }

    @Override
    public boolean hasChanged(int previousState) {
        return true;
    }

    @Override
    public void destroy(XQueryContext context, Sequence contextSequence) {
    }
}

