/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import com.ibm.icu.text.Collator;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.BitSet;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.Constants;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.XPathException;
import org.exist.xquery.functions.fn.FunEscapeURI;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.UntypedAtomicValue;

public class AnyURIValue
extends AtomicValue {
    public static final AnyURIValue EMPTY_URI = new AnyURIValue();
    static final int caseDiff = 32;
    static BitSet needEncoding = new BitSet(128);
    private final String uri;

    AnyURIValue() {
        this.uri = "";
    }

    public AnyURIValue(URI uri) {
        this.uri = uri.toString();
    }

    public AnyURIValue(XmldbURI uri) {
        this.uri = uri.toString();
    }

    public AnyURIValue(String s) throws XPathException {
        String wsTrimString = this.normalizeEscaped(StringValue.trimWhitespace(s));
        String escapedString = AnyURIValue.escape(wsTrimString);
        try {
            new URI(escapedString);
        }
        catch (URISyntaxException e) {
            try {
                XmldbURI.xmldbUriFor(escapedString);
            }
            catch (URISyntaxException ex) {
                throw new XPathException("Type error: the given string '" + s + "' cannot be cast to " + Type.getTypeName(this.getType()));
            }
        }
        s = StringValue.normalizeWhitespace(wsTrimString);
        this.uri = StringValue.collapseWhitespace(s);
    }

    public static String escape(String uri) {
        return FunEscapeURI.escape(uri, false);
    }

    @Override
    public int getType() {
        return 25;
    }

    @Override
    public String getStringValue() throws XPathException {
        return this.uri;
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        return !this.uri.isEmpty();
    }

    @Override
    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 25: {
                return this;
            }
            case 22: {
                return new StringValue(this.uri);
            }
            case 21: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        throw new XPathException("Type error: cannot cast xs:anyURI to " + Type.getTypeName(requiredType));
    }

    @Override
    public boolean compareTo(Collator collator, Constants.Comparison operator, AtomicValue other) throws XPathException {
        if (other.getType() == 25) {
            String otherURI = other.getStringValue();
            int cmp = this.uri.compareTo(otherURI);
            switch (operator) {
                case EQ: {
                    return cmp == 0;
                }
                case NEQ: {
                    return cmp != 0;
                }
                case GT: {
                    return cmp > 0;
                }
                case GTEQ: {
                    return cmp >= 0;
                }
                case LT: {
                    return cmp < 0;
                }
                case LTEQ: {
                    return cmp <= 0;
                }
            }
            throw new XPathException(ErrorCodes.XPTY0004, "cannot apply operator " + operator.generalComparisonSymbol + " to xs:anyURI");
        }
        AtomicValue atomicValue = null;
        try {
            atomicValue = other.convertTo(25);
        }
        catch (XPathException ex) {
            if (ex.getErrorCode() == ErrorCodes.FORG0001) {
                throw new XPathException(ErrorCodes.XPTY0004, "cannot apply operator " + operator.generalComparisonSymbol + " to xs:anyURI");
            }
            throw ex;
        }
        return this.compareTo(collator, operator, atomicValue);
    }

    @Override
    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 25) {
            String otherURI = other.getStringValue();
            return this.uri.compareTo(otherURI);
        }
        return this.compareTo(collator, other.convertTo(25));
    }

    @Override
    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("max is not supported for values of type xs:anyURI");
    }

    @Override
    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("min is not supported for values of type xs:anyURI");
    }

    @Override
    public int conversionPreference(Class<?> javaClass) {
        if (javaClass.isAssignableFrom(AnyURIValue.class)) {
            return 0;
        }
        if (javaClass == XmldbURI.class) {
            return 1;
        }
        if (javaClass == URI.class) {
            return 2;
        }
        if (javaClass == URL.class) {
            return 3;
        }
        if (javaClass == String.class || javaClass == CharSequence.class) {
            return 4;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public <T> T toJavaObject(Class<T> target) throws XPathException {
        if (target.isAssignableFrom(AnyURIValue.class)) {
            return (T)this;
        }
        if (target == XmldbURI.class) {
            return (T)this.toXmldbURI();
        }
        if (target == URI.class) {
            return (T)this.toURI();
        }
        if (target == URL.class) {
            try {
                return (T)new URL(this.uri);
            }
            catch (MalformedURLException e) {
                throw new XPathException(ErrorCodes.FORG0001, "failed to convert " + this.uri + " into a Java URL: " + e.getMessage(), (Throwable)e);
            }
        }
        if (target == String.class || target == CharSequence.class) {
            return (T)this.uri;
        }
        if (target == Object.class) {
            return (T)this.uri;
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }

    public XmldbURI toXmldbURI() throws XPathException {
        try {
            return XmldbURI.xmldbUriFor(this.uri, false);
        }
        catch (URISyntaxException e) {
            throw new XPathException(ErrorCodes.FORG0001, "failed to convert " + this.uri + " into an XmldbURI: " + e.getMessage(), (Throwable)e);
        }
    }

    public URI toURI() throws XPathException {
        try {
            return new URI(AnyURIValue.escape(this.uri));
        }
        catch (URISyntaxException e) {
            throw new XPathException(ErrorCodes.FORG0001, "failed to convert " + this.uri + " into an URI: " + e.getMessage(), (Throwable)e);
        }
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AnyURIValue) {
            return ((AnyURIValue)obj).uri.equals(this.uri);
        }
        return false;
    }

    private String normalizeEscaped(String in) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < in.length(); ++i) {
            char ch = in.charAt(i);
            if (ch == '%') {
                builder.append(ch);
                for (int j = 1; j <= 2 && i + j < in.length(); ++j) {
                    ch = in.charAt(i + j);
                    builder.append(Character.toUpperCase(ch));
                }
                i += 2;
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            needEncoding.set(i);
        }
        needEncoding.set(127);
        needEncoding.set(32);
        needEncoding.set(60);
        needEncoding.set(62);
        needEncoding.set(34);
        needEncoding.set(123);
        needEncoding.set(125);
        needEncoding.set(124);
        needEncoding.set(92);
        needEncoding.set(94);
        needEncoding.set(96);
    }
}

